/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support.command;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.support.command.CommandFailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.RpcCommand;
import com.weibo.api.motan.registry.support.command.RpcCommandUtil;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.CircularRecorder;
import com.weibo.api.motan.runtime.RuntimeInfo;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommandServiceManager
implements CommandListener,
ServiceListener,
RuntimeInfo {
    public static final String MOTAN_COMMAND_SWITCHER = "feature.motanrpc.command.enable";
    public static final String MOTAN_HISTORY_RECORD_SWITCHER = "feature.motanrpc.command.history.record";
    private static final Pattern IP_PATTERN = Pattern.compile("^!?[0-9.]*\\*?$");
    private static final int DEFAULT_WEIGHT = 1;
    private static final int MAX_WEIGHT = 100;
    private URL refUrl;
    private ConcurrentHashSet<NotifyListener> notifySet;
    private CommandFailbackRegistry registry;
    private Map<String, List<URL>> groupServiceCache;
    private String commandStringCache = "";
    private volatile RpcCommand commandCache;
    private RpcCommand staticCommand;
    private Map<String, Integer> weights;
    private final int recordInfoSize = 5;
    private final CircularRecorder<String> commandRecorder = new CircularRecorder(5);
    private final CircularRecorder<Object> notifyUrlsRecorder = new CircularRecorder(5);

    public CommandServiceManager(URL refUrl) {
        LoggerUtil.info("CommandServiceManager init url:" + refUrl.toFullStr());
        this.refUrl = refUrl;
        this.notifySet = new ConcurrentHashSet();
        this.groupServiceCache = new ConcurrentHashMap<String, List<URL>>();
        this.weights = new ConcurrentHashMap<String, Integer>();
        String mixGroupsString = refUrl.getParameter(URLParamType.mixGroups.getName());
        if (StringUtils.isNotBlank((CharSequence)mixGroupsString)) {
            String[] groups;
            LoggerUtil.info("CommandServiceManager process mixGroups:" + mixGroupsString);
            ArrayList<String> mergeGroups = new ArrayList<String>();
            mergeGroups.add(refUrl.getGroup());
            for (String group : groups = mixGroupsString.split(",")) {
                if (refUrl.getGroup().equals(group.trim())) continue;
                mergeGroups.add(group.trim());
            }
            if (mergeGroups.size() > 1) {
                this.staticCommand = new RpcCommand();
                ArrayList<RpcCommand.ClientCommand> clientCommandList = new ArrayList<RpcCommand.ClientCommand>();
                RpcCommand.ClientCommand clientCommand = new RpcCommand.ClientCommand();
                clientCommand.setPattern(refUrl.getPath());
                clientCommand.setCommandType(0);
                clientCommand.setIndex(1);
                clientCommand.setMergeGroups(mergeGroups);
                clientCommand.setRemark("static command of mix groups");
                clientCommand.setVersion("1.0");
                clientCommandList.add(clientCommand);
                this.staticCommand.setClientCommandList(clientCommandList);
                LoggerUtil.info("set static command. url: " + refUrl.toSimpleString() + ", merge group: " + mergeGroups);
            }
        }
    }

    @Override
    public void notifyService(URL serviceUrl, URL registryUrl, List<URL> urls) {
        if (this.registry == null) {
            throw new MotanFrameworkException("registry must be set.");
        }
        this.groupServiceCache.put(serviceUrl.getGroup(), urls);
        this.notifyListeners();
    }

    @Override
    public synchronized void notifyCommand(URL serviceUrl, String commandString) {
        LoggerUtil.info("CommandServiceManager notify command. service:" + serviceUrl.toSimpleString() + ", command:" + commandString);
        if (!MotanSwitcherUtil.isOpen(MOTAN_COMMAND_SWITCHER) || commandString == null) {
            LoggerUtil.info("command reset empty since switcher is close.");
            commandString = "";
        }
        if (!StringUtils.equals((CharSequence)commandString, (CharSequence)this.commandStringCache)) {
            if (MotanSwitcherUtil.isOpen(MOTAN_HISTORY_RECORD_SWITCHER)) {
                this.commandRecorder.add(commandString);
            }
            this.commandStringCache = commandString;
            this.commandCache = RpcCommandUtil.stringToCommand(commandString);
            if (this.commandCache == null && StringUtils.isNotBlank((CharSequence)commandString)) {
                LoggerUtil.warn("command parse fail, ignored! command:" + commandString);
            }
            this.notifyListeners();
            Set<String> groupKeys = this.groupServiceCache.keySet();
            for (String gk : groupKeys) {
                if (this.weights.containsKey(gk)) continue;
                this.groupServiceCache.remove(gk);
                URL urlTemp = this.refUrl.createCopy();
                urlTemp.addParameter(URLParamType.group.getName(), gk);
                this.registry.unsubscribeService(urlTemp, this);
            }
            if (this.commandCache == null || this.weights.isEmpty()) {
                LoggerUtil.info("reSub service" + this.refUrl.toSimpleString());
                this.registry.subscribeService(this.refUrl, this);
                this.discoverOneGroup(this.refUrl);
            }
        } else {
            LoggerUtil.info("command not change. url:" + serviceUrl.toSimpleString());
        }
    }

    private synchronized void notifyListeners() {
        ConcurrentHashMap<String, Integer> tempWeights = new ConcurrentHashMap<String, Integer>();
        List<URL> finalResult = this.discoverServiceWithCommand(tempWeights, this.commandCache);
        this.weights = tempWeights;
        for (NotifyListener notifyListener : this.notifySet) {
            try {
                notifyListener.notify(this.registry.getUrl(), finalResult);
            }
            catch (Exception e) {
                LoggerUtil.error("CommandServiceManager notify listener fail. listener:" + notifyListener.toString(), e);
            }
        }
        if (MotanSwitcherUtil.isOpen(MOTAN_HISTORY_RECORD_SWITCHER)) {
            this.notifyUrlsRecorder.add(finalResult.stream().map(URL::toSimpleString).collect(Collectors.toList()));
        }
    }

    List<URL> discoverServiceWithCommand(Map<String, Integer> weights, RpcCommand rpcCommand) {
        return this.discoverServiceWithCommand(weights, rpcCommand, NetUtils.getLocalIpString());
    }

    List<URL> discoverServiceWithCommand(Map<String, Integer> weights, RpcCommand rpcCommand, String localIP) {
        boolean hit;
        LinkedList<URL> mergedResult = new LinkedList<URL>();
        if (rpcCommand != null && !CollectionUtil.isEmpty(rpcCommand.getClientCommandList())) {
            for (RpcCommand.ClientCommand command : rpcCommand.getClientCommandList()) {
                hit = this.processTrafficCommand(command, weights, localIP, mergedResult);
                if (!hit) continue;
                LoggerUtil.info("discoverServiceWithCommand: hit with dynamic command. result size: " + mergedResult.size() + ", remark: " + command.getRemark());
                return mergedResult;
            }
        }
        if (this.staticCommand != null) {
            for (RpcCommand.ClientCommand command : this.staticCommand.getClientCommandList()) {
                hit = this.processTrafficCommand(command, weights, localIP, mergedResult);
                if (!hit) continue;
                LoggerUtil.info("discoverServiceWithCommand: hit with static command. result size: " + mergedResult.size() + ", remark: " + command.getRemark());
                return mergedResult;
            }
        }
        LoggerUtil.info("discoverServiceWithCommand: not hit any command.");
        return this.discoverOneGroup(this.refUrl);
    }

    private boolean processTrafficCommand(RpcCommand.ClientCommand command, Map<String, Integer> weights, String localIP, List<URL> mergedResult) {
        boolean hit = false;
        if (command.getCommandType() == null || command.getCommandType() == 0) {
            String path = this.refUrl.getPath();
            boolean match = RpcCommandUtil.match(command.getPattern(), path);
            if (match) {
                hit = true;
                if (!CollectionUtil.isEmpty(command.getMergeGroups())) {
                    boolean isMixMode;
                    try {
                        isMixMode = this.buildWeightsMap(weights, command);
                    }
                    catch (MotanFrameworkException e) {
                        LoggerUtil.warn("build weights map fail!" + e.getMessage());
                        weights.clear();
                        return false;
                    }
                    mergedResult.addAll(this.mergeResult(this.refUrl, weights, isMixMode));
                } else {
                    mergedResult.addAll(this.discoverOneGroup(this.refUrl));
                }
                LoggerUtil.info("mergedResult: size-" + mergedResult.size() + " --- " + mergedResult);
                if (!CollectionUtil.isEmpty(command.getRouteRules())) {
                    LoggerUtil.info("router: " + command.getRouteRules().toString());
                    for (String routeRule : command.getRouteRules()) {
                        int idx;
                        String[] fromTo = routeRule.replaceAll("\\s+", "").split("to");
                        if (fromTo.length != 2) {
                            this.routeRuleConfigError();
                            continue;
                        }
                        String from = fromTo[0];
                        String to = fromTo[1];
                        if (from.isEmpty() || to.isEmpty() || !IP_PATTERN.matcher(from).find() || !IP_PATTERN.matcher(to).find()) {
                            this.routeRuleConfigError();
                            continue;
                        }
                        boolean oppositeFrom = from.startsWith("!");
                        boolean oppositeTo = to.startsWith("!");
                        if (oppositeFrom) {
                            from = from.substring(1);
                        }
                        if (oppositeTo) {
                            to = to.substring(1);
                        }
                        boolean matchFrom = (idx = from.indexOf(42)) != -1 ? localIP.startsWith(from.substring(0, idx)) : localIP.equals(from);
                        if (oppositeFrom) {
                            matchFrom = !matchFrom;
                        }
                        LoggerUtil.info("matchFrom: " + matchFrom + ", local ip:" + localIP + ", from:" + from);
                        if (!matchFrom) continue;
                        Iterator<URL> iterator = mergedResult.iterator();
                        while (iterator.hasNext()) {
                            URL url = iterator.next();
                            if (url.getProtocol().equalsIgnoreCase("rule")) continue;
                            idx = to.indexOf(42);
                            boolean matchTo = idx != -1 ? url.getHost().startsWith(to.substring(0, idx)) : url.getHost().equals(to);
                            if (oppositeTo) {
                                boolean bl = matchTo = !matchTo;
                            }
                            if (matchTo) continue;
                            iterator.remove();
                            LoggerUtil.info("router To not match. url remove : " + url.toSimpleString());
                        }
                    }
                }
            }
        }
        return hit;
    }

    private boolean buildWeightsMap(Map<String, Integer> weights, RpcCommand.ClientCommand command) {
        boolean isMixMode = true;
        for (String rule : command.getMergeGroups()) {
            String[] gw = rule.split(":");
            int weight = 1;
            if (gw.length > 1) {
                isMixMode = false;
                try {
                    weight = Integer.parseInt(gw[1]);
                }
                catch (NumberFormatException e) {
                    LoggerUtil.warn("parse weight fail, default weight 1 will be used. weight string : " + rule);
                }
                if (weight < 1) {
                    weight = 1;
                } else if (weight > 100) {
                    weight = 100;
                }
            }
            weights.put(gw[0], weight);
        }
        return isMixMode;
    }

    private List<URL> mergeResult(URL url, Map<String, Integer> weights, boolean isMixMode) {
        ArrayList<URL> finalResult = new ArrayList<URL>();
        if (!isMixMode && weights.size() > 1) {
            URL ruleUrl = new URL("rule", url.getHost(), url.getPort(), url.getPath());
            StringBuilder weightsBuilder = new StringBuilder(64);
            for (Map.Entry<String, Integer> entry : weights.entrySet()) {
                weightsBuilder.append(entry.getKey()).append(':').append(entry.getValue()).append(',');
            }
            ruleUrl.addParameter(URLParamType.weights.getName(), weightsBuilder.deleteCharAt(weightsBuilder.length() - 1).toString());
            finalResult.add(ruleUrl);
            LoggerUtil.info("add weight rule url. weight: " + weightsBuilder);
        }
        for (String key : weights.keySet()) {
            if (this.groupServiceCache.containsKey(key)) {
                finalResult.addAll((Collection<URL>)this.groupServiceCache.get(key));
                continue;
            }
            URL urlTemp = url.createCopy();
            urlTemp.addParameter(URLParamType.group.getName(), key);
            finalResult.addAll(this.discoverOneGroup(urlTemp));
            this.registry.subscribeService(urlTemp, this);
        }
        return finalResult;
    }

    private List<URL> discoverOneGroup(URL urlCopy) {
        LoggerUtil.info("CommandServiceManager discover one group. url:" + urlCopy.toSimpleString());
        return this.groupServiceCache.computeIfAbsent(urlCopy.getGroup(), k -> this.registry.discoverService(urlCopy));
    }

    void setCommandCache(String command) {
        this.commandStringCache = command;
        this.commandCache = RpcCommandUtil.stringToCommand(this.commandStringCache);
        LoggerUtil.info("CommandServiceManager set command cache. command string:" + this.commandStringCache + ", command cache " + (this.commandCache == null ? "is null." : "is not null."));
    }

    void addNotifyListener(NotifyListener notifyListener) {
        this.notifySet.add(notifyListener);
    }

    void removeNotifyListener(NotifyListener notifyListener) {
        this.notifySet.remove(notifyListener);
    }

    public void setRegistry(CommandFailbackRegistry registry) {
        this.registry = registry;
    }

    private void routeRuleConfigError() {
        LoggerUtil.warn("\u8def\u7531\u89c4\u5219\u914d\u7f6e\u4e0d\u5408\u6cd5");
    }

    RpcCommand getStaticCommand() {
        return this.staticCommand;
    }

    Map<String, List<URL>> getGroupServiceCache() {
        return this.groupServiceCache;
    }

    RpcCommand getCommandCache() {
        return this.commandCache;
    }

    CommandFailbackRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Map<String, Object> getRuntimeInfo() {
        Map<String, Object> notifyRecords;
        Map<String, String> commandRecords;
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (this.commandCache != null) {
            infos.put("command", RpcCommandUtil.commandToString(this.commandCache));
        }
        if (this.staticCommand != null) {
            infos.put("staticCommand", RpcCommandUtil.commandToString(this.staticCommand));
        }
        if (!this.weights.isEmpty()) {
            infos.put("weight", this.weights);
        }
        if (!(commandRecords = this.commandRecorder.getRecords()).isEmpty()) {
            if (MotanSwitcherUtil.isOpen(MOTAN_HISTORY_RECORD_SWITCHER)) {
                infos.put("commandHistory", commandRecords);
            } else {
                this.commandRecorder.clear();
            }
        }
        if (!(notifyRecords = this.notifyUrlsRecorder.getRecords()).isEmpty()) {
            if (MotanSwitcherUtil.isOpen(MOTAN_HISTORY_RECORD_SWITCHER)) {
                infos.put("notifyHistory", notifyRecords);
            } else {
                this.notifyUrlsRecorder.clear();
            }
        }
        return infos;
    }

    static {
        MotanSwitcherUtil.initSwitcher(MOTAN_COMMAND_SWITCHER, true);
        MotanSwitcherUtil.initSwitcher(MOTAN_HISTORY_RECORD_SWITCHER, Boolean.parseBoolean(MotanGlobalConfigUtil.getConfig(MOTAN_HISTORY_RECORD_SWITCHER, "true")));
    }
}

