/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.Registry;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class AbstractRegistry
implements Registry {
    private ConcurrentHashMap<URL, Map<String, List<URL>>> subscribedCategoryResponses = new ConcurrentHashMap();
    private URL registryUrl;
    private Set<URL> registeredServiceUrls = new ConcurrentHashSet<URL>();
    protected String registryClassName = this.getClass().getSimpleName();

    public AbstractRegistry(URL url) {
        this.registryUrl = url.createCopy();
        MotanSwitcherUtil.initSwitcher("feature.configserver.heartbeat", false);
        MotanSwitcherUtil.registerSwitcherListener("feature.configserver.heartbeat", (key, value) -> {
            if (key != null && value != null) {
                if (value.booleanValue()) {
                    this.available(null);
                } else {
                    this.unavailable(null);
                }
            }
        });
    }

    @Override
    public void register(URL url) {
        if (url == null) {
            LoggerUtil.warn("[{}] register with malformed param, url is null", this.registryClassName);
            return;
        }
        LoggerUtil.info("[{}] Url ({}) will register to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        this.doRegister(this.removeUnnecessaryParams(url.createCopy()));
        this.registeredServiceUrls.add(url);
        if (MotanSwitcherUtil.isOpen("feature.configserver.heartbeat")) {
            this.available(url);
        }
    }

    @Override
    public void unregister(URL url) {
        if (url == null) {
            LoggerUtil.warn("[{}] unregister with malformed param, url is null", this.registryClassName);
            return;
        }
        LoggerUtil.info("[{}] Url ({}) will unregister to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        this.doUnregister(this.removeUnnecessaryParams(url.createCopy()));
        this.registeredServiceUrls.remove(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        if (url == null || listener == null) {
            LoggerUtil.warn("[{}] subscribe with malformed param, url:{}, listener:{}", this.registryClassName, url, listener);
            return;
        }
        LoggerUtil.info("[{}] Listener ({}) will subscribe to url ({}) in Registry [{}]", this.registryClassName, listener, url, this.registryUrl.getIdentity());
        this.doSubscribe(url.createCopy(), listener);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        if (url == null || listener == null) {
            LoggerUtil.warn("[{}] unsubscribe with malformed param, url:{}, listener:{}", this.registryClassName, url, listener);
            return;
        }
        LoggerUtil.info("[{}] Listener ({}) will unsubscribe from url ({}) in Registry [{}]", this.registryClassName, listener, url, this.registryUrl.getIdentity());
        this.doUnsubscribe(url.createCopy(), listener);
    }

    @Override
    public List<URL> discover(URL url) {
        ArrayList<URL> results;
        block5: {
            block4: {
                if (url == null) {
                    LoggerUtil.warn("[{}] discover with malformed param, refUrl is null", this.registryClassName);
                    return Collections.EMPTY_LIST;
                }
                url = url.createCopy();
                results = new ArrayList<URL>();
                Map<String, List<URL>> categoryUrls = this.subscribedCategoryResponses.get(url);
                if (categoryUrls == null || categoryUrls.isEmpty()) break block4;
                for (List<URL> urls : categoryUrls.values()) {
                    for (URL tempUrl : urls) {
                        results.add(tempUrl.createCopy());
                    }
                }
                break block5;
            }
            List<URL> urlsDiscovered = this.doDiscover(url);
            if (urlsDiscovered == null) break block5;
            for (URL u : urlsDiscovered) {
                results.add(u.createCopy());
            }
        }
        return results;
    }

    @Override
    public URL getUrl() {
        return this.registryUrl;
    }

    @Override
    public Collection<URL> getRegisteredServiceUrls() {
        return this.registeredServiceUrls;
    }

    @Override
    public void available(URL url) {
        LoggerUtil.info("[{}] Url ({}) will set to available to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        if (url != null) {
            this.doAvailable(this.removeUnnecessaryParams(url.createCopy()));
        } else {
            this.doAvailable(null);
        }
    }

    @Override
    public void unavailable(URL url) {
        LoggerUtil.info("[{}] Url ({}) will set to unavailable to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        if (url != null) {
            this.doUnavailable(this.removeUnnecessaryParams(url.createCopy()));
        } else {
            this.doUnavailable(null);
        }
    }

    protected List<URL> getCachedUrls(URL url) {
        Map<String, List<URL>> rsUrls = this.subscribedCategoryResponses.get(url);
        if (rsUrls == null || rsUrls.isEmpty()) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (List<URL> us : rsUrls.values()) {
            for (URL tempUrl : us) {
                urls.add(tempUrl.createCopy());
            }
        }
        return urls;
    }

    protected void notify(URL refUrl, NotifyListener listener, List<URL> urls) {
        if (listener == null || urls == null) {
            return;
        }
        HashMap nodeTypeUrlsInRs = new HashMap();
        for (URL surl : urls) {
            String nodeType = surl.getParameter(URLParamType.nodeType.getName(), URLParamType.nodeType.getValue());
            List oneNodeTypeUrls = (List)nodeTypeUrlsInRs.get(nodeType);
            if (oneNodeTypeUrls == null) {
                nodeTypeUrlsInRs.put(nodeType, new ArrayList());
                oneNodeTypeUrls = (List)nodeTypeUrlsInRs.get(nodeType);
            }
            oneNodeTypeUrls.add(surl);
        }
        Map<String, List<URL>> curls = this.subscribedCategoryResponses.get(refUrl);
        if (curls == null) {
            this.subscribedCategoryResponses.putIfAbsent(refUrl, new ConcurrentHashMap());
            curls = this.subscribedCategoryResponses.get(refUrl);
        }
        curls.putAll(nodeTypeUrlsInRs);
        for (List us : nodeTypeUrlsInRs.values()) {
            listener.notify(this.getUrl(), us);
        }
    }

    private URL removeUnnecessaryParams(URL url) {
        url.getParameters().remove(URLParamType.codec.getName());
        return url;
    }

    protected abstract void doRegister(URL var1);

    protected abstract void doUnregister(URL var1);

    protected abstract void doSubscribe(URL var1, NotifyListener var2);

    protected abstract void doUnsubscribe(URL var1, NotifyListener var2);

    protected abstract List<URL> doDiscover(URL var1);

    protected abstract void doAvailable(URL var1);

    protected abstract void doUnavailable(URL var1);

    @Override
    public Map<String, Object> getRuntimeInfo() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("registeredServiceUrls", this.registeredServiceUrls.stream().map(URL::getIdentity).collect(Collectors.toList()));
        HashMap subscribedInfos = new HashMap();
        for (Map.Entry<URL, Map<String, List<URL>>> entry : this.subscribedCategoryResponses.entrySet()) {
            subscribedInfos.put(entry.getKey().getIdentity(), entry.getValue().values().stream().flatMap(Collection::stream).map(URL::toTinyString).collect(Collectors.toList()));
        }
        infos.put("subscribedServiceUrls", subscribedInfos);
        return infos;
    }
}

