/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.common;

import com.weibo.api.motan.config.RegistryConfig;

public enum URLParamType {
    version("version", "1.0"),
    requestTimeout("requestTimeout", 200),
    requestIdFromClient("requestIdFromClient", 0),
    connectTimeout("connectTimeout", 1000),
    minWorkerThread("minWorkerThread", 20),
    maxWorkerThread("maxWorkerThread", 200),
    minClientConnection("minClientConnection", 2),
    maxClientConnection("maxClientConnection", 10),
    maxConnectionPerGroup("maxConnectionPerGroup", 0),
    maxContentLength("maxContentLength", 0xA00000),
    maxServerConnection("maxServerConnection", 100000),
    poolLifo("poolLifo", true),
    lazyInit("lazyInit", false),
    shareChannel("shareChannel", false),
    asyncInitConnection("asyncInitConnection", true),
    fusingThreshold("fusingThreshold", 10),
    serialize("serialization", "hessian2"),
    codec("codec", "motan"),
    endpointFactory("endpointFactory", "motan"),
    heartbeatFactory("heartbeatFactory", "motan"),
    switcherService("switcherService", "localSwitcherService"),
    group("group", "default_rpc"),
    clientGroup("clientGroup", "default_rpc"),
    accessLog("accessLog", false),
    actives("actives", 0),
    refreshTimestamp("refreshTimestamp", 0),
    nodeType("nodeType", "service"),
    export("export", ""),
    embed("embed", ""),
    registryRetryPeriod("registryRetryPeriod", 30000),
    excise("excise", RegistryConfig.Excise.excise_dynamic.getName()),
    cluster("cluster", "default"),
    loadbalance("loadbalance", "activeWeight"),
    haStrategy("haStrategy", "failover"),
    protocol("protocol", "motan"),
    path("path", ""),
    host("host", ""),
    port("port", 0),
    iothreads("iothreads", Runtime.getRuntime().availableProcessors() + 1),
    workerQueueSize("workerQueueSize", 0),
    acceptConnections("acceptConnections", 0),
    proxy("proxy", "jdk"),
    filter("filter", ""),
    usegz("usegz", false),
    mingzSize("mingzSize", 1000),
    application("application", "motan"),
    module("module", "motan"),
    retries("retries", 0),
    async("async", false),
    mock("mock", "false"),
    mean("mean", "2"),
    p90("p90", "4"),
    p99("p99", "10"),
    p999("p999", "70"),
    errorRate("errorRate", "0.01"),
    check("check", "true"),
    directUrl("directUrl", ""),
    registrySessionTimeout("registrySessionTimeout", 60000),
    slowThreshold("slowThreshold", 200),
    register("register", true),
    subscribe("subscribe", true),
    throwException("throwException", "true"),
    transExceptionStack("transExceptionStack", true),
    localServiceAddress("localServiceAddress", ""),
    backupRequestDelayTime("backupRequestDelayTime", 0),
    backupRequestDelayRatio("backupRequestDelayRatio", "0.4"),
    backupRequestSwitcherName("backupRequestSwitcherName", ""),
    backupRequestMaxRetryRatio("backupRequestMaxRetryRatio", "0.15"),
    weights("weights", ""),
    mixGroups("mixGroups", ""),
    providerProtectedStrategy("providerProtectedStrategy", "motan"),
    dynamic("dynamic", false),
    meshRegistryName("meshRegistryName", ""),
    proxyRegistryId("proxyRegistryId", ""),
    meshMPort("mport", 8002),
    needHealthCheck("needHealthCheck", true),
    proxyRegistryUrlString("proxyRegistryUrlString", ""),
    registerMeta("registerMeta", false),
    dynamicMeta("dynamicMeta", true);

    private final String name;
    private final String value;
    private long longValue;
    private int intValue;
    private boolean boolValue;

    private URLParamType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    private URLParamType(String name, long longValue) {
        this.name = name;
        this.value = String.valueOf(longValue);
        this.longValue = longValue;
    }

    private URLParamType(String name, int intValue) {
        this.name = name;
        this.value = String.valueOf(intValue);
        this.intValue = intValue;
    }

    private URLParamType(String name, boolean boolValue) {
        this.name = name;
        this.value = String.valueOf(boolValue);
        this.boolValue = boolValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public boolean getBooleanValue() {
        return this.boolValue;
    }
}

