/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.weibo.api.motan.util.LoggerUtil;

public class MathUtil {
    public static int parseInt(String intStr, int defaultValue) {
        try {
            return Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            LoggerUtil.debug("ParseInt false, for malformed intStr:" + intStr);
            return defaultValue;
        }
    }

    public static long parseLong(String longStr, long defaultValue) {
        try {
            return Long.parseLong(longStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int getNonNegative(int originValue) {
        return Integer.MAX_VALUE & originValue;
    }

    public static int getNonNegativeRange24bit(int originValue) {
        return 0xFFFFFF & originValue;
    }
}

