/*
 * Decompiled with CFR 0.152.
 */
package com.wefika.horizontalpicker;

import android.animation.ArgbEvaluator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.OverScroller;
import com.wefika.horizontalpicker.R;
import java.lang.ref.WeakReference;
import java.util.List;

public class HorizontalPicker
extends View {
    public static final String TAG = "HorizontalTimePicker";
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 4;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private VelocityTracker mVelocityTracker;
    private int mMinimumFlingVelocity;
    private int maximumFlingVelocity;
    private final int overscrollDistance;
    private int touchSlop;
    private CharSequence[] values;
    private BoringLayout[] layouts;
    private TextPaint textPaint;
    private BoringLayout.Metrics boringMetrics;
    private TextUtils.TruncateAt ellipsize;
    private int itemWidth;
    private RectF itemClipBounds;
    private RectF itemClipBoundsOffset;
    private float lastDownEventX;
    private OverScroller flingScrollerX;
    private OverScroller adjustScrollerX;
    private int previousScrollerX;
    private boolean scrollingX;
    private int pressedItem = -1;
    private ColorStateList textColor;
    private OnItemSelected onItemSelected;
    private OnItemClicked onItemClicked;
    private int selectedItem;
    private EdgeEffect leftEdgeEffect;
    private EdgeEffect rightEdgeEffect;
    private Marquee marquee;
    private int marqueeRepeatLimit = 3;
    private float dividerSize = 0.0f;
    private int sideItems = 1;
    private TextDirectionHeuristicCompat textDir;
    private final PickerTouchHelper touchHelper;

    public HorizontalPicker(Context context) {
        this(context, null);
    }

    public HorizontalPicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.horizontalPickerStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HorizontalPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        CharSequence[] values;
        TextPaint paint = new TextPaint();
        paint.setAntiAlias(true);
        this.textPaint = paint;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HorizontalPicker, defStyle, 0);
        int ellipsize = 3;
        int sideItems = this.sideItems;
        try {
            this.textColor = a.getColorStateList(R.styleable.HorizontalPicker_android_textColor);
            if (this.textColor == null) {
                this.textColor = ColorStateList.valueOf((int)-16777216);
            }
            values = a.getTextArray(R.styleable.HorizontalPicker_values);
            ellipsize = a.getInt(R.styleable.HorizontalPicker_android_ellipsize, ellipsize);
            this.marqueeRepeatLimit = a.getInt(R.styleable.HorizontalPicker_android_marqueeRepeatLimit, this.marqueeRepeatLimit);
            this.dividerSize = a.getDimension(R.styleable.HorizontalPicker_dividerSize, this.dividerSize);
            sideItems = a.getInt(R.styleable.HorizontalPicker_sideItems, sideItems);
            float textSize = a.getDimension(R.styleable.HorizontalPicker_android_textSize, -1.0f);
            if (textSize > -1.0f) {
                this.setTextSize(textSize);
            }
        }
        finally {
            a.recycle();
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        Paint.FontMetricsInt fontMetricsInt = this.textPaint.getFontMetricsInt();
        this.boringMetrics = new BoringLayout.Metrics();
        this.boringMetrics.ascent = fontMetricsInt.ascent;
        this.boringMetrics.bottom = fontMetricsInt.bottom;
        this.boringMetrics.descent = fontMetricsInt.descent;
        this.boringMetrics.leading = fontMetricsInt.leading;
        this.boringMetrics.top = fontMetricsInt.top;
        this.boringMetrics.width = this.itemWidth;
        this.setWillNotDraw(false);
        this.flingScrollerX = new OverScroller(context);
        this.adjustScrollerX = new OverScroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 4;
        this.overscrollDistance = configuration.getScaledOverscrollDistance();
        this.previousScrollerX = Integer.MIN_VALUE;
        this.setValues(values);
        this.setSideItems(sideItems);
        this.touchHelper = new PickerTouchHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.touchHelper);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
            int heightText = (int)(Math.abs(fontMetrics.ascent) + Math.abs(fontMetrics.descent));
            height = heightMode == Integer.MIN_VALUE ? Math.min(heightSize, heightText) : (heightText += this.getPaddingTop() + this.getPaddingBottom());
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int saveCount = canvas.getSaveCount();
        canvas.save();
        int selectedItem = this.selectedItem;
        float itemWithPadding = (float)this.itemWidth + this.dividerSize;
        canvas.translate(itemWithPadding * (float)this.sideItems, 0.0f);
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                RectF clipBounds;
                this.textPaint.setColor(this.getTextColor(i));
                BoringLayout layout = this.layouts[i];
                int saveCountHeight = canvas.getSaveCount();
                canvas.save();
                float x = 0.0f;
                float lineWidth = layout.getLineWidth(0);
                if (lineWidth > (float)this.itemWidth) {
                    x = this.isRtl(this.values[i]) ? (x += (lineWidth - (float)this.itemWidth) / 2.0f) : (x -= (lineWidth - (float)this.itemWidth) / 2.0f);
                }
                if (this.marquee != null && i == selectedItem) {
                    x += this.marquee.getScroll();
                }
                canvas.translate(-x, (float)((canvas.getHeight() - layout.getHeight()) / 2));
                if (x == 0.0f) {
                    clipBounds = this.itemClipBounds;
                } else {
                    clipBounds = this.itemClipBoundsOffset;
                    clipBounds.set(this.itemClipBounds);
                    clipBounds.offset(x, 0.0f);
                }
                canvas.clipRect(clipBounds);
                layout.draw(canvas);
                if (this.marquee != null && i == selectedItem && this.marquee.shouldDrawGhost()) {
                    canvas.translate(this.marquee.getGhostOffset(), 0.0f);
                    layout.draw(canvas);
                }
                canvas.restoreToCount(saveCountHeight);
                canvas.translate(itemWithPadding, 0.0f);
            }
        }
        canvas.restoreToCount(saveCount);
        this.drawEdgeEffect(canvas, this.leftEdgeEffect, 270);
        this.drawEdgeEffect(canvas, this.rightEdgeEffect, 90);
    }

    @TargetApi(value=17)
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.textDir = this.getTextDirectionHeuristic();
    }

    private boolean isRtl(CharSequence text) {
        if (this.textDir == null) {
            this.textDir = this.getTextDirectionHeuristic();
        }
        return this.textDir.isRtl(text, 0, text.length());
    }

    private TextDirectionHeuristicCompat getTextDirectionHeuristic() {
        if (Build.VERSION.SDK_INT < 17) {
            return TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        }
        boolean defaultIsRtl = this.getLayoutDirection() == 1;
        switch (this.getTextDirection()) {
            default: {
                return defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristicsCompat.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristicsCompat.LTR;
            }
            case 4: {
                return TextDirectionHeuristicsCompat.RTL;
            }
            case 5: 
        }
        return TextDirectionHeuristicsCompat.LOCALE;
    }

    private void remakeLayout() {
        if (this.layouts != null && this.layouts.length > 0 && this.getWidth() > 0) {
            for (int i = 0; i < this.layouts.length; ++i) {
                this.layouts[i].replaceOrMake(this.values[i], this.textPaint, this.itemWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.boringMetrics, false, this.ellipsize, this.itemWidth);
            }
        }
    }

    private void drawEdgeEffect(Canvas canvas, EdgeEffect edgeEffect, int degrees) {
        if (canvas == null || edgeEffect == null || degrees != 90 && degrees != 270) {
            return;
        }
        if (!edgeEffect.isFinished()) {
            int restoreCount = canvas.getSaveCount();
            int width = this.getWidth();
            int height = this.getHeight();
            canvas.rotate((float)degrees);
            if (degrees == 270) {
                canvas.translate((float)(-height), (float)Math.max(0, this.getScrollX()));
            } else {
                canvas.translate(0.0f, -(Math.max((float)this.getScrollRange(), this.getScaleX()) + (float)width));
            }
            edgeEffect.setSize(height, width);
            if (edgeEffect.draw(canvas)) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.postInvalidateOnAnimation();
                } else {
                    this.postInvalidate();
                }
            }
            canvas.restoreToCount(restoreCount);
        }
    }

    private int getTextColor(int item) {
        int scrollX = this.getScrollX();
        int color = this.textColor.getDefaultColor();
        int itemWithPadding = (int)((float)this.itemWidth + this.dividerSize);
        if (scrollX > itemWithPadding * item - itemWithPadding / 2 && scrollX < itemWithPadding * (item + 1) - itemWithPadding / 2) {
            int position = scrollX - itemWithPadding / 2;
            color = this.getColor(position, item);
        } else if (item == this.pressedItem) {
            color = this.textColor.getColorForState(new int[]{16842919}, color);
        }
        return color;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.calculateItemSize(w, h);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action = event.getActionMasked();
        switch (action) {
            case 2: {
                float pulledToX;
                float currentMoveX = event.getX();
                int deltaMoveX = (int)(this.lastDownEventX - currentMoveX);
                if (!this.scrollingX && (Math.abs(deltaMoveX) <= this.touchSlop || this.values == null || this.values.length <= 0)) break;
                if (!this.scrollingX) {
                    deltaMoveX = 0;
                    this.pressedItem = -1;
                    this.scrollingX = true;
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.stopMarqueeIfNeeded();
                }
                int range = this.getScrollRange();
                if (this.overScrollBy(deltaMoveX, 0, this.getScrollX(), 0, range, 0, this.overscrollDistance, 0, true)) {
                    this.mVelocityTracker.clear();
                }
                if ((pulledToX = (float)(this.getScrollX() + deltaMoveX)) < 0.0f) {
                    this.leftEdgeEffect.onPull((float)deltaMoveX / (float)this.getWidth());
                    if (!this.rightEdgeEffect.isFinished()) {
                        this.rightEdgeEffect.onRelease();
                    }
                } else if (pulledToX > (float)range) {
                    this.rightEdgeEffect.onPull((float)deltaMoveX / (float)this.getWidth());
                    if (!this.leftEdgeEffect.isFinished()) {
                        this.leftEdgeEffect.onRelease();
                    }
                }
                this.lastDownEventX = currentMoveX;
                this.invalidate();
                break;
            }
            case 0: {
                if (!this.adjustScrollerX.isFinished()) {
                    this.adjustScrollerX.forceFinished(true);
                } else if (!this.flingScrollerX.isFinished()) {
                    this.flingScrollerX.forceFinished(true);
                } else {
                    this.scrollingX = false;
                }
                this.lastDownEventX = event.getX();
                if (!this.scrollingX) {
                    this.pressedItem = this.getPositionFromTouch(event.getX());
                }
                this.invalidate();
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.maximumFlingVelocity);
                int initialVelocityX = (int)velocityTracker.getXVelocity();
                if (this.scrollingX && Math.abs(initialVelocityX) > this.mMinimumFlingVelocity) {
                    this.flingX(initialVelocityX);
                } else if (this.values != null) {
                    float positionX = event.getX();
                    if (!this.scrollingX) {
                        int itemPos = this.getPositionOnScreen(positionX);
                        int relativePos = itemPos - this.sideItems;
                        if (relativePos == 0) {
                            this.selectItem();
                        } else {
                            this.smoothScrollBy(relativePos);
                        }
                    } else if (this.scrollingX) {
                        this.finishScrolling();
                    }
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                if (this.leftEdgeEffect != null) {
                    this.leftEdgeEffect.onRelease();
                    this.rightEdgeEffect.onRelease();
                }
            }
            case 3: {
                this.pressedItem = -1;
                this.invalidate();
                if (this.leftEdgeEffect == null) break;
                this.leftEdgeEffect.onRelease();
                this.rightEdgeEffect.onRelease();
            }
        }
        return true;
    }

    private void selectItem() {
        if (this.onItemClicked != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    HorizontalPicker.this.onItemClicked.onItemClicked(HorizontalPicker.this.getSelectedItem());
                }
            });
        }
        this.adjustToNearestItemX();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyDown(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                this.selectItem();
                return true;
            }
            case 21: {
                this.smoothScrollBy(-1);
                return true;
            }
            case 22: {
                this.smoothScrollBy(1);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        if (this.touchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    public void computeScroll() {
        this.computeScrollX();
    }

    public void getFocusedRect(Rect r) {
        super.getFocusedRect(r);
    }

    public void setOnItemSelectedListener(OnItemSelected onItemSelected) {
        this.onItemSelected = onItemSelected;
    }

    public void setOnItemClickedListener(OnItemClicked onItemClicked) {
        this.onItemClicked = onItemClicked;
    }

    public int getSelectedItem() {
        int x = this.getScrollX();
        return this.getPositionFromCoordinates(x);
    }

    public void setSelectedItem(int index) {
        this.selectedItem = index;
        this.scrollToItem(index);
    }

    public int getMarqueeRepeatLimit() {
        return this.marqueeRepeatLimit;
    }

    public void setMarqueeRepeatLimit(int marqueeRepeatLimit) {
        this.marqueeRepeatLimit = marqueeRepeatLimit;
    }

    public int getSideItems() {
        return this.sideItems;
    }

    public void setSideItems(int sideItems) {
        if (this.sideItems < 0) {
            throw new IllegalArgumentException("Number of items on each side must be grater or equal to 0.");
        }
        if (this.sideItems != sideItems) {
            this.sideItems = sideItems;
            this.calculateItemSize(this.getWidth(), this.getHeight());
        }
    }

    public CharSequence[] getValues() {
        return this.values;
    }

    public void setValues(CharSequence[] values) {
        if (this.values != values) {
            this.values = values;
            if (this.values != null) {
                this.layouts = new BoringLayout[this.values.length];
                for (int i = 0; i < this.layouts.length; ++i) {
                    this.layouts[i] = new BoringLayout(this.values[i], this.textPaint, this.itemWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, this.boringMetrics, false, this.ellipsize, this.itemWidth);
                }
            } else {
                this.layouts = new BoringLayout[0];
            }
            if (this.getWidth() > 0) {
                this.startMarqueeIfNeeded();
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelectedItem(ss.mSelItem);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mSelItem = this.selectedItem;
        return savedState;
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode != 2) {
            Context context = this.getContext();
            this.leftEdgeEffect = new EdgeEffect(context);
            this.rightEdgeEffect = new EdgeEffect(context);
        } else {
            this.leftEdgeEffect = null;
            this.rightEdgeEffect = null;
        }
        super.setOverScrollMode(overScrollMode);
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.ellipsize;
    }

    public void setEllipsize(TextUtils.TruncateAt ellipsize) {
        if (this.ellipsize != ellipsize) {
            this.ellipsize = ellipsize;
            this.remakeLayout();
            this.invalidate();
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.scrollTo(scrollX, scrollY);
        if (!this.flingScrollerX.isFinished() && clampedX) {
            this.flingScrollerX.springBack(scrollX, scrollY, 0, this.getScrollRange(), 0, 0);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
    }

    private int getPositionFromTouch(float x) {
        return this.getPositionFromCoordinates((int)((float)this.getScrollX() - ((float)this.itemWidth + this.dividerSize) * ((float)this.sideItems + 0.5f) + x));
    }

    private void computeScrollX() {
        OverScroller scroller = this.flingScrollerX;
        if (scroller.isFinished() && (scroller = this.adjustScrollerX).isFinished()) {
            return;
        }
        if (scroller.computeScrollOffset()) {
            int currentScrollerX = scroller.getCurrX();
            if (this.previousScrollerX == Integer.MIN_VALUE) {
                this.previousScrollerX = scroller.getStartX();
            }
            int range = this.getScrollRange();
            if (this.previousScrollerX >= 0 && currentScrollerX < 0) {
                this.leftEdgeEffect.onAbsorb((int)scroller.getCurrVelocity());
            } else if (this.previousScrollerX <= range && currentScrollerX > range) {
                this.rightEdgeEffect.onAbsorb((int)scroller.getCurrVelocity());
            }
            this.overScrollBy(currentScrollerX - this.previousScrollerX, 0, this.previousScrollerX, this.getScrollY(), this.getScrollRange(), 0, this.overscrollDistance, 0, false);
            this.previousScrollerX = currentScrollerX;
            if (scroller.isFinished()) {
                this.onScrollerFinishedX(scroller);
            }
            this.postInvalidate();
        }
    }

    private void flingX(int velocityX) {
        this.previousScrollerX = Integer.MIN_VALUE;
        this.flingScrollerX.fling(this.getScrollX(), this.getScrollY(), -velocityX, 0, 0, (int)((float)this.itemWidth + this.dividerSize) * (this.values.length - 1), 0, 0, this.getWidth() / 2, 0);
        this.invalidate();
    }

    private void adjustToNearestItemX() {
        int x = this.getScrollX();
        int item = Math.round((float)x / ((float)this.itemWidth + this.dividerSize * 1.0f));
        if (item < 0) {
            item = 0;
        } else if (item > this.values.length) {
            item = this.values.length;
        }
        this.selectedItem = item;
        int itemX = (this.itemWidth + (int)this.dividerSize) * item;
        int deltaX = itemX - x;
        this.previousScrollerX = Integer.MIN_VALUE;
        this.adjustScrollerX.startScroll(x, 0, deltaX, 0, 800);
        this.invalidate();
    }

    private void calculateItemSize(int w, int h) {
        int items = this.sideItems * 2 + 1;
        int totalPadding = (int)this.dividerSize * (items - 1);
        this.itemWidth = (w - totalPadding) / items;
        this.itemClipBounds = new RectF(0.0f, 0.0f, (float)this.itemWidth, (float)h);
        this.itemClipBoundsOffset = new RectF(this.itemClipBounds);
        this.scrollToItem(this.selectedItem);
        this.remakeLayout();
        this.startMarqueeIfNeeded();
    }

    private void onScrollerFinishedX(OverScroller scroller) {
        if (scroller == this.flingScrollerX) {
            this.finishScrolling();
        }
    }

    private void finishScrolling() {
        this.adjustToNearestItemX();
        this.scrollingX = false;
        this.startMarqueeIfNeeded();
        if (this.onItemSelected != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    HorizontalPicker.this.onItemSelected.onItemSelected(HorizontalPicker.this.getPositionFromCoordinates(HorizontalPicker.this.getScrollX()));
                }
            });
        }
    }

    private void startMarqueeIfNeeded() {
        this.stopMarqueeIfNeeded();
        int item = this.getSelectedItem();
        if (this.layouts != null && this.layouts.length > item) {
            BoringLayout layout = this.layouts[item];
            if (this.ellipsize == TextUtils.TruncateAt.MARQUEE && (float)this.itemWidth < layout.getLineWidth(0)) {
                this.marquee = new Marquee(this, (Layout)layout, this.isRtl(this.values[item]));
                this.marquee.start(this.marqueeRepeatLimit);
            }
        }
    }

    private void stopMarqueeIfNeeded() {
        if (this.marquee != null) {
            this.marquee.stop();
            this.marquee = null;
        }
    }

    private int getPositionOnScreen(float x) {
        return (int)(x / ((float)this.itemWidth + this.dividerSize));
    }

    private void smoothScrollBy(int i) {
        int deltaMoveX = (this.itemWidth + (int)this.dividerSize) * i;
        deltaMoveX = this.getRelativeInBound(deltaMoveX);
        this.previousScrollerX = Integer.MIN_VALUE;
        this.flingScrollerX.startScroll(this.getScrollX(), 0, deltaMoveX, 0);
        this.stopMarqueeIfNeeded();
        this.invalidate();
    }

    private int getColor(int scrollX, int position) {
        int selectedColor;
        int defaultColor;
        int itemWithPadding = (int)((float)this.itemWidth + this.dividerSize);
        float proportion = Math.abs(1.0f * (float)scrollX % (float)itemWithPadding / 2.0f / ((float)itemWithPadding / 2.0f));
        proportion = (double)proportion > 0.5 ? (proportion -= 0.5f) : 0.5f - proportion;
        proportion *= 2.0f;
        if (this.pressedItem == position) {
            defaultColor = this.textColor.getColorForState(new int[]{16842919}, this.textColor.getDefaultColor());
            selectedColor = this.textColor.getColorForState(new int[]{16842919, 0x10100A1}, defaultColor);
        } else {
            defaultColor = this.textColor.getDefaultColor();
            selectedColor = this.textColor.getColorForState(new int[]{0x10100A1}, defaultColor);
        }
        return (Integer)new ArgbEvaluator().evaluate(proportion, (Object)selectedColor, (Object)defaultColor);
    }

    private void setTextSize(float size) {
        if (size != this.textPaint.getTextSize()) {
            this.textPaint.setTextSize(size);
            this.requestLayout();
            this.invalidate();
        }
    }

    private int getPositionFromCoordinates(int x) {
        return Math.round((float)x / ((float)this.itemWidth + this.dividerSize));
    }

    private void scrollToItem(int index) {
        this.scrollTo((this.itemWidth + (int)this.dividerSize) * index, 0);
    }

    private int getRelativeInBound(int x) {
        int scrollX = this.getScrollX();
        return this.getInBoundsX(scrollX + x) - scrollX;
    }

    private int getInBoundsX(int x) {
        if (x < 0) {
            x = 0;
        } else if (x > (this.itemWidth + (int)this.dividerSize) * (this.values.length - 1)) {
            x = (this.itemWidth + (int)this.dividerSize) * (this.values.length - 1);
        }
        return x;
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.values != null && this.values.length != 0) {
            scrollRange = Math.max(0, (this.itemWidth + (int)this.dividerSize) * (this.values.length - 1));
        }
        return scrollRange;
    }

    private static class PickerTouchHelper
    extends ExploreByTouchHelper {
        private HorizontalPicker mPicker;

        public PickerTouchHelper(HorizontalPicker picker) {
            super((View)picker);
            this.mPicker = picker;
        }

        protected int getVirtualViewAt(float x, float y) {
            float itemWidth = (float)this.mPicker.itemWidth + this.mPicker.dividerSize;
            float position = (float)this.mPicker.getScrollX() + x - itemWidth * (float)this.mPicker.sideItems;
            float item = position / itemWidth;
            if (item < 0.0f || item > (float)this.mPicker.values.length) {
                return Integer.MIN_VALUE;
            }
            return (int)item;
        }

        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            float itemWidth = (float)this.mPicker.itemWidth + this.mPicker.dividerSize;
            float position = (float)this.mPicker.getScrollX() - itemWidth * (float)this.mPicker.sideItems;
            int first = (int)(position / itemWidth);
            int items = this.mPicker.sideItems * 2 + 1;
            if (position % itemWidth != 0.0f) {
                ++items;
            }
            if (first < 0) {
                items += first;
                first = 0;
            } else if (first + items > this.mPicker.values.length) {
                items = this.mPicker.values.length - first;
            }
            for (int i = 0; i < items; ++i) {
                virtualViewIds.add(first + i);
            }
        }

        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.mPicker.values[virtualViewId]);
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
            float itemWidth = (float)this.mPicker.itemWidth + this.mPicker.dividerSize;
            float scrollOffset = (float)this.mPicker.getScrollX() - itemWidth * (float)this.mPicker.sideItems;
            int left = (int)((float)virtualViewId * itemWidth - scrollOffset);
            int right = left + this.mPicker.itemWidth;
            node.setContentDescription(this.mPicker.values[virtualViewId]);
            node.setBoundsInParent(new Rect(left, 0, right, this.mPicker.getHeight()));
            node.addAction(16);
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            return false;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        private int mSelItem;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelItem = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelItem);
        }

        public String toString() {
            return "HorizontalPicker.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selItem=" + this.mSelItem + "}";
        }
    }

    private static final class Marquee
    extends Handler {
        private static final float MARQUEE_DELTA_MAX = 0.07f;
        private static final int MARQUEE_DELAY = 1200;
        private static final int MARQUEE_RESTART_DELAY = 1200;
        private static final int MARQUEE_RESOLUTION = 33;
        private static final int MARQUEE_PIXELS_PER_SECOND = 30;
        private static final byte MARQUEE_STOPPED = 0;
        private static final byte MARQUEE_STARTING = 1;
        private static final byte MARQUEE_RUNNING = 2;
        private static final int MESSAGE_START = 1;
        private static final int MESSAGE_TICK = 2;
        private static final int MESSAGE_RESTART = 3;
        private final WeakReference<HorizontalPicker> mView;
        private final WeakReference<Layout> mLayout;
        private byte mStatus = 0;
        private final float mScrollUnit;
        private float mMaxScroll;
        private float mMaxFadeScroll;
        private float mGhostStart;
        private float mGhostOffset;
        private float mFadeStop;
        private int mRepeatLimit;
        private float mScroll;
        private boolean mRtl;

        Marquee(HorizontalPicker v, Layout l, boolean rtl) {
            float density = v.getContext().getResources().getDisplayMetrics().density;
            float scrollUnit = 30.0f * density / 33.0f;
            this.mScrollUnit = rtl ? -scrollUnit : scrollUnit;
            this.mView = new WeakReference<HorizontalPicker>(v);
            this.mLayout = new WeakReference<Layout>(l);
            this.mRtl = rtl;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mStatus = (byte)2;
                    this.tick();
                    break;
                }
                case 2: {
                    this.tick();
                    break;
                }
                case 3: {
                    if (this.mStatus != 2) break;
                    if (this.mRepeatLimit >= 0) {
                        --this.mRepeatLimit;
                    }
                    this.start(this.mRepeatLimit);
                }
            }
        }

        void tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.removeMessages(2);
            HorizontalPicker view = (HorizontalPicker)((Object)this.mView.get());
            Layout layout = (Layout)this.mLayout.get();
            if (view != null && layout != null && (view.isFocused() || view.isSelected())) {
                this.mScroll += this.mScrollUnit;
                if (Math.abs(this.mScroll) > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    if (this.mRtl) {
                        this.mScroll *= -1.0f;
                    }
                    this.sendEmptyMessageDelayed(3, 1200L);
                } else {
                    this.sendEmptyMessageDelayed(2, 33L);
                }
                view.invalidate();
            }
        }

        void stop() {
            this.mStatus = 0;
            this.removeMessages(1);
            this.removeMessages(3);
            this.removeMessages(2);
            this.resetScroll();
        }

        private void resetScroll() {
            this.mScroll = 0.0f;
            HorizontalPicker view = (HorizontalPicker)((Object)this.mView.get());
            if (view != null) {
                view.invalidate();
            }
        }

        void start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            HorizontalPicker view = (HorizontalPicker)((Object)this.mView.get());
            Layout layout = (Layout)this.mLayout.get();
            if (view != null && layout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = view.itemWidth;
                float lineWidth = layout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                if (this.mRtl) {
                    this.mGhostOffset *= -1.0f;
                }
                view.invalidate();
                this.sendEmptyMessageDelayed(1, 1200L);
            }
        }

        float getGhostOffset() {
            return this.mGhostOffset;
        }

        float getScroll() {
            return this.mScroll;
        }

        float getMaxFadeScroll() {
            return this.mMaxFadeScroll;
        }

        boolean shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        boolean shouldDrawGhost() {
            return this.mStatus == 2 && Math.abs(this.mScroll) > this.mGhostStart;
        }

        boolean isRunning() {
            return this.mStatus == 2;
        }

        boolean isStopped() {
            return this.mStatus == 0;
        }
    }

    public static interface OnItemClicked {
        public void onItemClicked(int var1);
    }

    public static interface OnItemSelected {
        public void onItemSelected(int var1);
    }
}

