/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.serialization;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.serializer.serialization.JsonLdDataTypeSerializer;
import com.weedow.schemaorg.serializer.spec.DataTypeSpecificationService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdDataTypeSerializerModifier
extends BeanSerializerModifier {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdDataTypeSerializerModifier.class);
    private final Map<Class<?>, JsonSerializer<?>> cache = new HashMap();

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        JsonSerializer jsonSerializer = this.getJsonSerializer(serializer, beanDesc.getType());
        return jsonSerializer != null ? jsonSerializer : super.modifySerializer(config, beanDesc, serializer);
    }

    private JsonSerializer<?> getJsonSerializer(JsonSerializer<?> serializer, JavaType type) {
        Class rawClass = type.getRawClass();
        if (JsonLdDataType.class.isAssignableFrom(rawClass)) {
            return this.cache.computeIfAbsent(rawClass, clazz -> {
                JsonLdDataTypeSerializer jsonLdDataTypeSerializer = serializer.getClass().getAnnotation(JsonLdDataTypeSerializer.class);
                if (!(jsonLdDataTypeSerializer == null || jsonLdDataTypeSerializer.exactType() && serializer.handledType() != rawClass)) {
                    return serializer;
                }
                Class dataTypeClass = rawClass;
                JsonSerializer ser = DataTypeSpecificationService.getInstance().getSerializer(dataTypeClass);
                if (ser == null) {
                    LOG.warn("Could not find the Json-LD DataType Serializer for class {}", (Object)rawClass);
                    ser = serializer;
                }
                return ser;
            });
        }
        return null;
    }
}

