/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.deserialization.processor;

import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.commons.model.JsonLdFieldTypes;
import com.weedow.schemaorg.commons.model.JsonLdNode;
import com.weedow.schemaorg.serializer.converter.ConversionService;
import com.weedow.schemaorg.serializer.converter.ConversionServiceImpl;
import com.weedow.schemaorg.serializer.deserialization.processor.PostProcessor;
import com.weedow.schemaorg.serializer.spec.DataTypeSpecificationService;
import com.weedow.schemaorg.serializer.utils.SerializerUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerPostProcessorImpl
implements PostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DeserializerPostProcessorImpl.class);
    private static final List<Class<?>> SCALAR_TYPES = Arrays.asList(Boolean.class, String.class, Number.class);
    private final ConversionService conversionService = new ConversionServiceImpl();

    @Override
    public <T> T process(T obj) {
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            for (Object o : coll) {
                this.process(o);
            }
        } else {
            this.fixObjectFieldValues(obj);
        }
        return obj;
    }

    private void fixObjectFieldValues(Object obj) {
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                this.fixObjectFieldValue(obj, field);
            }
        }
    }

    private void fixObjectFieldValue(Object obj, Field field) {
        Object fieldValue = DeserializerPostProcessorImpl.getFieldValue(obj, field);
        if (fieldValue != null) {
            Class<?> fieldValueClass = fieldValue.getClass();
            if (JsonLdNode.class.isAssignableFrom(fieldValueClass) && !Enum.class.isAssignableFrom(fieldValueClass)) {
                this.fixObjectFieldValues(fieldValue);
            } else if (field.getType() == Object.class) {
                this.updateObjectFieldValue(field, fieldValue).ifPresent(o -> DeserializerPostProcessorImpl.setFieldValue(obj, field, o));
            } else if (field.getType() == List.class) {
                this.fixListFieldValue(field, (List)fieldValue);
            }
        }
    }

    private void fixListFieldValue(Field field, List<?> list) {
        Class genericType = (Class)SerializerUtils.getTypeParameter(field.getGenericType());
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            Class<?> valueClass = value.getClass();
            if (JsonLdNode.class.isAssignableFrom(valueClass) && !Enum.class.isAssignableFrom(valueClass)) {
                this.fixObjectFieldValues(value);
                continue;
            }
            if (genericType != Object.class) continue;
            int index = i;
            this.updateObjectFieldValue(field, value).ifPresent(o -> list.set(index, o));
        }
    }

    private Optional<?> updateObjectFieldValue(Field field, Object fieldValue) {
        List<Class<JsonLdDataType<?>>> fieldTypes;
        Optional<Object> opt = Optional.empty();
        JsonLdFieldTypes jsonLdFieldTypes = field.getDeclaredAnnotation(JsonLdFieldTypes.class);
        if (jsonLdFieldTypes != null && !(fieldTypes = DeserializerPostProcessorImpl.filterAndSort(jsonLdFieldTypes.value(), fieldValue)).isEmpty()) {
            for (Class<JsonLdDataType<?>> fieldType : fieldTypes) {
                JsonLdDataType<?> value = this.conversionService.convert(fieldValue, fieldType);
                if (value == null) continue;
                opt = Optional.of(value);
                break;
            }
        }
        return opt;
    }

    private static List<Class<JsonLdDataType<?>>> filterAndSort(Class<?>[] fieldTypes, Object fieldValue) {
        if (DeserializerPostProcessorImpl.isScalarValue(fieldValue)) {
            return Arrays.stream(fieldTypes).filter(JsonLdDataType.class::isAssignableFrom).map(clazz -> clazz).sorted(DataTypeSpecificationService.getInstance().getDataTypeComparator()).toList();
        }
        return Collections.emptyList();
    }

    private static boolean isScalarValue(Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        Class<?> fieldValueClass = fieldValue.getClass();
        return SCALAR_TYPES.stream().anyMatch(clazz -> clazz.isAssignableFrom(fieldValueClass));
    }

    private static void setFieldValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            LOG.warn("Could not set value {} to '{}': {}", new Object[]{value, field.getName(), e.getMessage()});
        }
    }

    private static Object getFieldValue(Object obj, Field field) {
        Object value;
        try {
            field.setAccessible(true);
            value = field.get(obj);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Could not access to value of field {}: {}", (Object)field.getName(), (Object)e.getMessage());
            value = null;
        }
        return value;
    }
}

