/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.deserialization;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.weedow.schemaorg.serializer.deserialization.PackageScanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdTypeFactory
extends TypeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdTypeFactory.class);
    private final Map<String, Class<?>> types = new HashMap();

    public JsonLdTypeFactory(Map<String, Class<?>> otherTypes) {
        super((LookupCache)new LRUMap(16, 200));
        try (InputStream schemaOrgJavaProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema-org-java.properties");){
            Properties properties = new Properties();
            properties.load(schemaOrgJavaProperties);
            JsonLdTypeFactory.consumeProperty(properties, "schema.org.java.package.commons", clazz -> this.types.put(clazz.getSimpleName(), (Class<?>)clazz));
            JsonLdTypeFactory.consumeProperty(properties, "schema.org.java.package.data-type", clazz -> this.types.put(clazz.getName(), (Class<?>)clazz));
            JsonLdTypeFactory.consumeProperty(properties, "schema.org.java.package.model", clazz -> this.types.put("interface." + clazz.getSimpleName(), (Class<?>)clazz));
            JsonLdTypeFactory.consumeProperty(properties, "schema.org.java.package.model-impl", clazz -> this.types.put(clazz.getSimpleName(), (Class<?>)clazz));
            JsonLdTypeFactory.consumeProperty(properties, "schema.org.java.package.model", clazz -> {
                String simpleName = clazz.getSimpleName();
                Class<?> enumerationClass = this.types.get("interface.Enumeration");
                String key = enumerationClass != null && enumerationClass.isAssignableFrom((Class<?>)clazz) ? simpleName + "Enum" : simpleName + "Impl";
                this.types.put(simpleName, this.types.getOrDefault(key, (Class<?>)clazz));
            });
        }
        catch (IOException e) {
            LOG.warn("Could not load the properties file {}", (Object)"schema-org-java.properties");
        }
        if (otherTypes != null) {
            this.types.putAll(otherTypes);
        }
    }

    private static void consumeProperty(Properties properties, String key, Consumer<Class<?>> consumer) {
        String packageName = properties.getProperty(key);
        PackageScanner.getClassesIn(packageName).forEach(consumer);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class clazz = this.types.get(className);
        return clazz != null ? clazz : super.findClass(className);
    }
}

