/*
 * Decompiled with CFR 0.152.
 */
package com.weedow.schemaorg.serializer.converter.impl;

import com.weedow.schemaorg.commons.model.JsonLdDataType;
import com.weedow.schemaorg.serializer.converter.impl.AbstractConverter;

public class BooleanConverter
extends AbstractConverter {
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final BooleanConverter INSTANCE = new BooleanConverter();

    private BooleanConverter() {
    }

    @Override
    public boolean supports(Class<? extends JsonLdDataType<?>> jsonLdDataType, Class<?> targetType) {
        return (Boolean.class.isAssignableFrom(targetType) || String.class.isAssignableFrom(targetType)) && jsonLdDataType.getSimpleName().equals("Boolean");
    }

    @Override
    public Boolean getValue(Object source) {
        if (source instanceof Boolean) {
            Boolean bool = (Boolean)source;
            return bool;
        }
        return BooleanConverter.toBooleanObject(source.toString());
    }

    private static Boolean toBooleanObject(String str) {
        if (TRUE.equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if (FALSE.equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

