/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterDataType;
import javax.lang.model.element.Element;

public abstract class RequestParameter
extends DecoratedElement<Element>
implements Comparable<RequestParameter> {
    private ResourceParameterConstraints constraints;
    private ResourceParameterDataType dataType;

    protected RequestParameter(Element declaration, DecoratedProcessingEnvironment env) {
        super(declaration, env);
    }

    public abstract String getParameterName();

    public abstract String getDefaultValue();

    public abstract String getTypeName();

    public abstract boolean isMultivalued();

    public abstract boolean isRequired();

    public abstract DecoratedProcessingEnvironment getEnvironment();

    public final ResourceParameterConstraints getConstraints() {
        if (this.constraints == null) {
            this.constraints = this.loadConstraints();
        }
        return this.constraints;
    }

    public ResourceParameterDataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.loadDataType();
        }
        return this.dataType;
    }

    protected abstract ResourceParameterConstraints loadConstraints();

    protected abstract ResourceParameterDataType loadDataType();

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestParameter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String parameterName = this.getParameterName();
        String typeName = this.getTypeName();
        RequestParameter that = (RequestParameter)o;
        String thatParameterName = that.getParameterName();
        String thatTypeName = that.getTypeName();
        return !(parameterName == null ? thatParameterName != null : !parameterName.equals(thatParameterName)) && !(typeName == null ? thatTypeName != null : !typeName.equals(thatTypeName));
    }

    public final int hashCode() {
        String parameterName = this.getParameterName();
        String typeName = this.getTypeName();
        int result = parameterName != null ? parameterName.hashCode() : 0;
        result = 31 * result + (typeName != null ? typeName.hashCode() : 0);
        return result;
    }

    @Override
    public final int compareTo(RequestParameter other) {
        String parameterName = this.getParameterName();
        String typeName = this.getTypeName();
        RequestParameter that = other;
        String thatParameterName = that.getParameterName();
        String thatTypeName = that.getTypeName();
        return (typeName + parameterName).compareTo(thatTypeName + thatParameterName);
    }
}

