/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.TypeElementComparator;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.api.impl.PathSummaryImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.model.SpringController;
import com.webcohesion.enunciate.util.PathSortStrategy;
import com.webcohesion.enunciate.util.PathSummaryComparator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;

public class AnnotationBasedResourceGroupImpl
implements ResourceGroup {
    private final String contextPath;
    private final String label;
    private final List<Resource> resources;
    private final PathSortStrategy sortStrategy;
    private String description;

    public AnnotationBasedResourceGroupImpl(String contextPath, String label, List<Resource> resources, PathSortStrategy sortStrategy) {
        this.contextPath = contextPath;
        this.label = label;
        this.resources = resources;
        this.sortStrategy = sortStrategy;
    }

    public String getSlug() {
        return "resource_" + AnnotationBasedResourceGroupImpl.scrubLabelForSlug(this.label);
    }

    public String getRelativeContextPath() {
        return this.contextPath;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSortKey() {
        return this.label;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.description;
        }
        String description = null;
        TreeSet<SpringController> definingResourceClasses = new TreeSet<SpringController>((Comparator<SpringController>)new TypeElementComparator());
        int methodCount = 0;
        block0: for (Resource resource : this.resources) {
            for (Method method : resource.getMethods()) {
                ++methodCount;
                if (description != null && method.getDescription() != null && !description.equals(method.getDescription())) {
                    description = null;
                    break block0;
                }
                description = method.getDescription();
                if (description == null || !description.trim().isEmpty()) continue;
                description = null;
            }
            if (!(resource instanceof ResourceImpl)) continue;
            definingResourceClasses.add(((ResourceImpl)resource).requestMapping.getParent());
        }
        if ((methodCount > 1 || description == null) && definingResourceClasses.size() == 1) {
            description = ((SpringController)((Object)definingResourceClasses.iterator().next())).getDocValue();
        }
        return description;
    }

    public void setDescriptionIfNull(String description) {
        if (this.description == null) {
            this.description = description;
        }
    }

    public String getDeprecated() {
        String deprecated = null;
        for (Resource resource : this.resources) {
            deprecated = resource.getDeprecated();
            if (deprecated != null) continue;
            return null;
        }
        return deprecated;
    }

    public List<PathSummary> getPaths() {
        HashMap<String, PathSummary> paths = new HashMap<String, PathSummary>();
        for (Resource resource : this.resources) {
            PathSummary pathSummary = (PathSummary)paths.get(resource.getPath());
            if (pathSummary == null) {
                pathSummary = new PathSummaryImpl(resource.getPath(), new TreeSet<String>(), resource.getStyles());
                paths.put(resource.getPath(), pathSummary);
            }
            for (Method method : resource.getMethods()) {
                pathSummary.getMethods().add(method.getHttpMethod());
            }
        }
        ArrayList<PathSummary> pathSummaries = new ArrayList<PathSummary>(paths.values());
        Collections.sort(pathSummaries, new PathSummaryComparator(this.sortStrategy));
        return pathSummaries;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    private static String scrubLabelForSlug(String facetValue) {
        return facetValue.replace('/', '_').replace(':', '_').replace('{', '_').replace('}', '_').replace(' ', '_');
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return Collections.emptyMap();
    }

    public Set<Facet> getFacets() {
        TreeSet<Facet> facets = new TreeSet<Facet>();
        for (Resource resource : this.resources) {
            facets.addAll(resource.getFacets());
        }
        return facets;
    }

    public JavaDoc getJavaDoc() {
        return JavaDoc.EMPTY;
    }

    public Set<String> getStyles() {
        TreeSet<String> styles = new TreeSet<String>();
        for (Resource resource : this.resources) {
            styles.addAll(resource.getStyles());
        }
        return styles;
    }
}

