/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.rt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;

public class EnunciateApplication
extends Application {
    private static Logger LOG = Logger.getLogger(EnunciateApplication.class.getName());
    private static final String JAXB_CONTEXT_RESOLVER_CLASSNAME = "com.webcohesion.enunciate.rt.EnunciateJaxbContextResolver";

    public Set<Class<?>> getClasses() {
        String contextClass;
        BufferedReader reader;
        URL contextClassList;
        Enumeration<URL> contextClassLists;
        HashSet classes = new HashSet();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            contextClassLists = classloader.getResources("/jaxrs-resource-classes.list");
            while (contextClassLists.hasMoreElements()) {
                contextClassList = contextClassLists.nextElement();
                reader = new BufferedReader(new InputStreamReader(contextClassList.openStream(), "utf-8"));
                contextClass = reader.readLine();
                while (contextClass != null) {
                    try {
                        classes.add(classloader.loadClass(contextClass));
                    }
                    catch (Throwable e) {
                        this.onUnknownResourceClass(contextClass, e);
                    }
                    contextClass = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            LOG.warning("Unable to read all JAX-RS resource classes (" + e.getMessage() + ")");
        }
        try {
            contextClassLists = classloader.getResources("/jaxrs-provider-classes.list");
            while (contextClassLists.hasMoreElements()) {
                contextClassList = contextClassLists.nextElement();
                reader = new BufferedReader(new InputStreamReader(contextClassList.openStream(), "utf-8"));
                contextClass = reader.readLine();
                while (contextClass != null) {
                    if (!JAXB_CONTEXT_RESOLVER_CLASSNAME.equals(contextClass)) {
                        try {
                            classes.add(classloader.loadClass(contextClass));
                        }
                        catch (Throwable e) {
                            this.onUnknownProviderClass(contextClass, e);
                        }
                    }
                    contextClass = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            LOG.warning("Unable to read all JAX-RS provider classes (" + e.getMessage() + ")");
        }
        return classes;
    }

    public Set<Object> getSingletons() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        HashSet<Object> singletons = new HashSet<Object>();
        try {
            singletons.add(classloader.loadClass(JAXB_CONTEXT_RESOLVER_CLASSNAME).newInstance());
        }
        catch (Throwable e) {
            LOG.info("com.webcohesion.enunciate.rt.EnunciateJaxbContextResolver cannot be instantiated (" + e.getMessage() + ").");
        }
        return singletons;
    }

    protected void onUnknownProviderClass(String contextClass, Throwable e) {
        LOG.warning("Unable to load JAX-RS provider class " + contextClass + " (" + e.getMessage() + ")");
    }

    protected void onUnknownResourceClass(String contextClass, Throwable e) {
        LOG.warning("Unable to load JAX-RS resource class " + contextClass + " (" + e.getMessage() + ")");
    }
}

