/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.objc_client;

import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.modules.jaxb.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.EnumValue;
import com.webcohesion.enunciate.modules.objc_client.ObjCXMLClientModule;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.beans.Introspector;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.PackageElement;

public class NameForEnumConstantMethod
implements TemplateMethodModelEx {
    private final String pattern;
    private final String projectLabel;
    private final Map<String, String> namespaces2ids;
    private final Map<String, String> packages2ids;

    public NameForEnumConstantMethod(String pattern, String projectLabel, Map<String, String> namespaces2ids, Map<String, String> packages2ids) {
        this.pattern = pattern;
        this.packages2ids = packages2ids;
        this.projectLabel = ObjCXMLClientModule.scrubIdentifier(projectLabel);
        this.namespaces2ids = namespaces2ids;
    }

    public Object exec(List list) throws TemplateModelException {
        PackageElement pckg;
        if (list.size() < 1) {
            throw new TemplateModelException("The nameForEnumConstant method must have an enum type definition and an enum constant declaration as parameters.");
        }
        BeansWrapper wrapper = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build();
        Object unwrapped = wrapper.unwrap((TemplateModel)list.get(0));
        if (!(unwrapped instanceof EnumValue)) {
            throw new TemplateModelException("The nameForEnumConstant method must have an enum value as a parameter.");
        }
        EnumValue enumValue = (EnumValue)unwrapped;
        EnumTypeDefinition typeDefinition = enumValue.getTypeDefinition();
        String name = ObjCXMLClientModule.scrubIdentifier(typeDefinition.getName());
        String simpleName = ObjCXMLClientModule.scrubIdentifier(typeDefinition.getSimpleName().toString());
        String clientName = ObjCXMLClientModule.scrubIdentifier(typeDefinition.getClientSimpleName());
        String simpleNameDecap = ObjCXMLClientModule.scrubIdentifier(Introspector.decapitalize(simpleName));
        String clientNameDecap = ObjCXMLClientModule.scrubIdentifier(Introspector.decapitalize(clientName));
        if (name == null) {
            name = "anonymous_" + clientNameDecap;
        }
        String packageName = (pckg = (PackageElement)typeDefinition.getPackage().getDelegate()) == null ? "" : pckg.getQualifiedName().toString();
        String packageIdentifier = this.packages2ids.containsKey(packageName) ? ObjCXMLClientModule.scrubIdentifier(this.packages2ids.get(packageName)) : ObjCXMLClientModule.scrubIdentifier(packageName);
        String nsid = ObjCXMLClientModule.scrubIdentifier(this.namespaces2ids.get(typeDefinition.getNamespace()));
        String constantName = ObjCXMLClientModule.scrubIdentifier(enumValue.getSimpleName().toString());
        String constantClientName = ObjCXMLClientModule.scrubIdentifier(enumValue.getAnnotation(ClientName.class) != null ? ((ClientName)enumValue.getAnnotation(ClientName.class)).value() : constantName);
        return String.format(this.pattern, this.projectLabel, nsid, name, clientName, clientNameDecap, simpleName, simpleNameDecap, packageIdentifier, constantClientName, constantName);
    }
}

