/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.objc_client;

import com.webcohesion.enunciate.modules.jaxb.EnunciateJaxbContext;
import com.webcohesion.enunciate.modules.jaxb.model.Attribute;
import com.webcohesion.enunciate.modules.jaxb.model.ElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.LocalElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.RootElementDeclaration;
import com.webcohesion.enunciate.modules.jaxb.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jaxb.model.Value;
import com.webcohesion.enunciate.modules.jaxb.model.types.MapXmlType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlClassType;
import com.webcohesion.enunciate.modules.jaxb.model.types.XmlType;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.xml.namespace.QName;

public class ReferencedNamespacesMethod
implements TemplateMethodModelEx {
    private final EnunciateJaxbContext context;

    public ReferencedNamespacesMethod(EnunciateJaxbContext context) {
        this.context = context;
    }

    public Object exec(List list) throws TemplateModelException {
        TypeDefinition typeDefinition;
        if (list.size() < 1) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build().unwrap(from);
        if (!(unwrapped instanceof ElementDeclaration)) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        ElementDeclaration elementDeclaration = (ElementDeclaration)unwrapped;
        HashSet<String> referencedNamespaces = new HashSet<String>();
        referencedNamespaces.add(elementDeclaration.getNamespace());
        if (elementDeclaration instanceof RootElementDeclaration) {
            TypeDefinition typeDef = ((RootElementDeclaration)elementDeclaration).getTypeDefinition();
            this.addReferencedNamespaces(typeDef, referencedNamespaces);
        } else if (elementDeclaration instanceof LocalElementDeclaration && (typeDefinition = this.context.findTypeDefinition((Element)((LocalElementDeclaration)elementDeclaration).getElementType())) != null) {
            this.addReferencedNamespaces(typeDefinition, referencedNamespaces);
        }
        referencedNamespaces.remove(null);
        referencedNamespaces.remove("");
        referencedNamespaces.remove("http://www.w3.org/2001/XMLSchema");
        return referencedNamespaces;
    }

    private void addReferencedNamespaces(TypeDefinition typeDefinition, Set<String> referencedNamespaces) {
        for (Attribute attribute : typeDefinition.getAttributes()) {
            QName ref = attribute.getRef();
            if (ref != null) {
                referencedNamespaces.add(ref.getNamespaceURI());
                continue;
            }
            this.addReferencedNamespaces(attribute.getBaseType(), referencedNamespaces);
        }
        for (com.webcohesion.enunciate.modules.jaxb.model.Element element : typeDefinition.getElements()) {
            for (com.webcohesion.enunciate.modules.jaxb.model.Element choice : element.getChoices()) {
                QName ref = choice.getRef();
                if (ref != null) {
                    referencedNamespaces.add(ref.getNamespaceURI());
                    continue;
                }
                this.addReferencedNamespaces(choice.getBaseType(), referencedNamespaces);
            }
        }
        Value value = typeDefinition.getValue();
        if (value != null) {
            this.addReferencedNamespaces(value.getBaseType(), referencedNamespaces);
        }
        if (typeDefinition instanceof QNameEnumTypeDefinition) {
            for (Object qnameValue : ((QNameEnumTypeDefinition)typeDefinition).getEnumValues().values()) {
                QName qname = (QName)qnameValue;
                if (qname == null) continue;
                referencedNamespaces.add(qname.getNamespaceURI());
            }
        }
        this.addReferencedNamespaces(typeDefinition.getBaseType(), referencedNamespaces);
    }

    private void addReferencedNamespaces(XmlType xmlType, Set<String> referencedNamespaces) {
        if (!xmlType.isAnonymous()) {
            referencedNamespaces.add(xmlType.getNamespace());
        } else if (xmlType instanceof MapXmlType) {
            referencedNamespaces.add(((MapXmlType)xmlType).getKeyType().getNamespace());
            referencedNamespaces.add(((MapXmlType)xmlType).getValueType().getNamespace());
        } else if (xmlType instanceof XmlClassType) {
            this.addReferencedNamespaces(((XmlClassType)xmlType).getTypeDefinition(), referencedNamespaces);
        }
    }
}

