/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MACUtil {
    private MACUtil() {
    }

    public static byte[] calculateHmacSHA256(byte[] message, byte[] secret) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret, "HmacSHA256");
            mac.init(secretKeySpec);
            return mac.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

