/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MACUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HKDFUtil {
    private static final int HASH_LENGTH = 32;

    private HKDFUtil() {
    }

    public static @NonNull byte[] calculateHKDFSHA256(@NonNull byte[] ikm, @NonNull byte[] salt, @NonNull byte[] info, int outputLength) {
        byte[] pseudoRandomKey = HKDFUtil.extract(ikm, salt);
        return HKDFUtil.expand(pseudoRandomKey, info, outputLength);
    }

    static @NonNull byte[] extract(@NonNull byte[] ikm, @NonNull byte[] salt) {
        AssertUtil.notNull(ikm, "ikm must not be null");
        if (salt == null || salt.length == 0) {
            salt = new byte[32];
        }
        return MACUtil.calculateHmacSHA256(ikm, salt);
    }

    static @NonNull byte[] extract(@NonNull byte[] ikm) {
        return HKDFUtil.extract(ikm, null);
    }

    static @NonNull byte[] expand(@NonNull byte[] key, @NonNull byte[] info, int outputLength) {
        AssertUtil.notNull(key, "key must not be null");
        if (outputLength <= 0) {
            throw new IllegalArgumentException("outputLength must be positive");
        }
        if (outputLength > 8160) {
            throw new IllegalArgumentException("outputLength must be less than or equal to 255*HashLen");
        }
        if (info == null) {
            info = new byte[]{};
        }
        int n = outputLength % 32 == 0 ? outputLength / 32 : outputLength / 32 + 1;
        byte[] hashRound = new byte[]{};
        ByteBuffer generatedBytes = ByteBuffer.allocate(Math.multiplyExact(n, 32));
        Mac mac = HKDFUtil.createMac(key);
        for (int roundNum = 1; roundNum <= n; ++roundNum) {
            mac.reset();
            byte[] secret = ByteBuffer.allocate(hashRound.length + info.length + 1).put(hashRound).put(info).put((byte)roundNum).array();
            hashRound = mac.doFinal(secret);
            generatedBytes.put(hashRound);
        }
        byte[] result = new byte[outputLength];
        generatedBytes.rewind();
        generatedBytes.get(result, 0, outputLength);
        return result;
    }

    private static @NonNull Mac createMac(@NonNull byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

