/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> @Nullable List<T> unmodifiableList(@Nullable List<? extends T> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    public static <T> @Nullable Set<T> unmodifiableSet(@Nullable Set<? extends T> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    public static <T> @NonNull Set<T> unmodifiableSet(T ... items) {
        HashSet<T> set = new HashSet<T>(Arrays.asList(items));
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> @Nullable Map<K, V> unmodifiableMap(@Nullable Map<? extends K, ? extends V> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }
}

