/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class UnsignedNumberUtil {
    public static final short UNSIGNED_BYTE_MAX = 255;
    public static final int UNSIGNED_SHORT_MAX = 65535;
    public static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    public static final BigInteger UNSIGNED_LONG_MAX = new BigInteger("18446744073709551615");
    private static final String OUT_OF_RANGE_ERROR = "argument is out of range";

    private UnsignedNumberUtil() {
    }

    public static short getUnsignedByte(byte value) {
        return (short)Byte.toUnsignedInt(value);
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        return Short.toUnsignedInt(byteBuffer.getShort());
    }

    public static int getUnsignedShort(byte[] bytes) {
        if (bytes.length != 2) {
            throw new IllegalArgumentException("byte array must be 2 bytes");
        }
        return UnsignedNumberUtil.getUnsignedShort(ByteBuffer.wrap(bytes));
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return Integer.toUnsignedLong(byteBuffer.getInt());
    }

    public static long getUnsignedInt(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("byte array must be 4 bytes");
        }
        return UnsignedNumberUtil.getUnsignedInt(ByteBuffer.wrap(bytes));
    }

    public static BigInteger getUnsignedLong(ByteBuffer byteBuffer) {
        byte[] buffer = new byte[8];
        byteBuffer.get(buffer);
        return new BigInteger(1, buffer);
    }

    public static byte[] toBytes(int ushortValue) {
        if (!UnsignedNumberUtil.isWithinUnsignedShort(ushortValue)) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR);
        }
        byte[] bytes = new byte[2];
        bytes[1] = (byte)(0xFF & ushortValue);
        bytes[0] = (byte)(0xFF & ushortValue >>> 8);
        return bytes;
    }

    public static byte[] toBytes(long uintValue) {
        if (!UnsignedNumberUtil.isWithinUnsignedInt(uintValue)) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR);
        }
        byte[] bytes = new byte[4];
        bytes[3] = (byte)(0xFFL & uintValue);
        bytes[2] = (byte)(0xFFL & uintValue >>> 8);
        bytes[1] = (byte)(0xFFL & uintValue >>> 16);
        bytes[0] = (byte)(0xFFL & uintValue >>> 24);
        return bytes;
    }

    public static byte[] toBytes(BigInteger unsignedLongValue) {
        if (!UnsignedNumberUtil.isWithinUnsignedLong(unsignedLongValue)) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR);
        }
        byte[] bytes = unsignedLongValue.toByteArray();
        byte[] buffer = new byte[8];
        int offset = 8 - bytes.length;
        for (int i = Math.max(0, offset); i < 8; ++i) {
            buffer[i] = bytes[i - offset];
        }
        return buffer;
    }

    public static boolean isWithinUnsignedByte(int value) {
        return value <= 255 && value >= 0;
    }

    public static boolean isWithinUnsignedShort(int value) {
        return value <= 65535 && value >= 0;
    }

    public static boolean isWithinUnsignedInt(long value) {
        return value <= 0xFFFFFFFFL && value >= 0L;
    }

    public static boolean isWithinUnsignedLong(BigInteger value) {
        return value.bitLength() <= 64 && value.compareTo(BigInteger.valueOf(0L)) >= 0;
    }
}

