/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test;

import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;

public class KeyUtil {
    private static final SecureRandom secureRandom = new SecureRandom();

    private KeyUtil() {
    }

    public static PrivateKey loadECPrivateKey(byte[] bytes) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    public static KeyPairGenerator createECKeyPairGenerator() {
        try {
            return KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    public static KeyPair createECKeyPair(byte[] seed, ECParameterSpec ecParameterSpec) {
        KeyPairGenerator keyPairGenerator = KeyUtil.createECKeyPairGenerator();
        try {
            SecureRandom random;
            if (seed != null) {
                random = SecureRandom.getInstance("SHA1PRNG");
                random.setSeed(seed);
            } else {
                random = secureRandom;
            }
            keyPairGenerator.initialize(ecParameterSpec, random);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
    }

    public static KeyPair createECKeyPair(byte[] seed) {
        return KeyUtil.createECKeyPair(seed, ECUtil.P_256_SPEC);
    }

    public static KeyPair createECKeyPair(ECParameterSpec ecParameterSpec) {
        return KeyUtil.createECKeyPair(null, ecParameterSpec);
    }

    public static KeyPair createECKeyPair() {
        return KeyUtil.createECKeyPair((byte[])null);
    }

    public static KeyPair createRSAKeyPair() {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4), new SecureRandom());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new UnexpectedCheckedException((Throwable)e);
        }
        return keyPairGenerator.generateKeyPair();
    }
}

