/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.model;

import com.webauthn4j.client.CollectedClientData;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.registry.Registry;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.AuthenticatorExtensionInput;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.SupportedExtensionsAuthenticatorExtensionInput;
import com.webauthn4j.test.authenticator.model.GetAssertionRequest;
import com.webauthn4j.test.authenticator.model.GetAssertionResponse;
import com.webauthn4j.test.authenticator.model.MakeCredentialRequest;
import com.webauthn4j.test.authenticator.model.MakeCredentialResponse;
import com.webauthn4j.test.authenticator.model.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.ClientExtensionInput;
import com.webauthn4j.test.client.PublicKeyCredentialCreationOptions;
import com.webauthn4j.test.client.PublicKeyCredentialRequestOptions;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.test.client.SupportedExtensionsClientExtensionInput;
import com.webauthn4j.test.client.UserVerificationRequirement;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WebAuthnModelAuthenticatorAdaptor
implements AuthenticatorAdaptor {
    private WebAuthnModelAuthenticator webAuthnModelAuthenticator = new WebAuthnModelAuthenticator();
    private CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter(new Registry());

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData, RegistrationEmulationOption registrationEmulationOption) {
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        boolean requireUserVerification = this.getEffectiveUserVerificationRequirementForAssertion(publicKeyCredentialCreationOptions.getAuthenticatorSelection().getUserVerificationRequirement());
        MakeCredentialRequest makeCredentialRequest = new MakeCredentialRequest();
        makeCredentialRequest.setHash(clientDataHash);
        makeCredentialRequest.setRpEntity(publicKeyCredentialCreationOptions.getRp());
        makeCredentialRequest.setUserEntity(publicKeyCredentialCreationOptions.getUser());
        makeCredentialRequest.setRequireResidentKey(publicKeyCredentialCreationOptions.getAuthenticatorSelection().isRequireResidentKey());
        makeCredentialRequest.setRequireUserPresence(!requireUserVerification);
        makeCredentialRequest.setRequireUserVerification(requireUserVerification);
        makeCredentialRequest.setCredTypesAndPublicKeyAlgs(publicKeyCredentialCreationOptions.getPubKeyCredParams());
        makeCredentialRequest.setExcludeCredentialDescriptorList(publicKeyCredentialCreationOptions.getExcludeCredentials());
        makeCredentialRequest.setExtensions(this.convertExtensions(publicKeyCredentialCreationOptions.getExtensions()));
        MakeCredentialResponse makeCredentialResponse = this.webAuthnModelAuthenticator.makeCredential(makeCredentialRequest, registrationEmulationOption);
        return new CredentialCreationResponse(makeCredentialResponse.getAttestationObject());
    }

    @Override
    public CredentialCreationResponse register(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, CollectedClientData collectedClientData) {
        return this.register(publicKeyCredentialCreationOptions, collectedClientData, new RegistrationEmulationOption());
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.authenticate(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    @Override
    public CredentialRequestResponse authenticate(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        byte[] clientDataHash = MessageDigestUtil.createSHA256().digest(collectedClientDataBytes);
        boolean requireUserVerification = this.getEffectiveUserVerificationRequirementForAssertion(publicKeyCredentialRequestOptions.getUserVerification());
        GetAssertionRequest getAssertionRequest = new GetAssertionRequest();
        getAssertionRequest.setRpId(publicKeyCredentialRequestOptions.getRpId());
        getAssertionRequest.setHash(clientDataHash);
        getAssertionRequest.setAllowCredentialDescriptorList(publicKeyCredentialRequestOptions.getAllowCredentials());
        getAssertionRequest.setRequireUserPresence(!requireUserVerification);
        getAssertionRequest.setRequireUserVerification(requireUserVerification);
        getAssertionRequest.setExtensions(this.convertExtensions(publicKeyCredentialRequestOptions.getExtensions()));
        GetAssertionResponse getAssertionResponse = this.webAuthnModelAuthenticator.getAssertion(getAssertionRequest, authenticationEmulationOption);
        return new CredentialRequestResponse(getAssertionResponse.getCredentialId(), collectedClientDataBytes, getAssertionResponse.getAuthenticatorData(), getAssertionResponse.getSignature(), getAssertionResponse.getUserHandle());
    }

    private Map<String, AuthenticatorExtensionInput> convertExtensions(Map<String, ClientExtensionInput> extensions) {
        if (extensions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AuthenticatorExtensionInput> map = new HashMap<String, AuthenticatorExtensionInput>();
        for (Map.Entry<String, ClientExtensionInput> clientExtensionInputEntry : extensions.entrySet()) {
            String extensionIdentifier = clientExtensionInputEntry.getKey();
            if (!extensionIdentifier.equals("exts")) continue;
            SupportedExtensionsClientExtensionInput clientExtensionInput = (SupportedExtensionsClientExtensionInput)clientExtensionInputEntry.getValue();
            map.put("exts", new SupportedExtensionsAuthenticatorExtensionInput((Boolean)clientExtensionInput.getValue()));
        }
        return map;
    }

    private boolean getEffectiveUserVerificationRequirementForAssertion(UserVerificationRequirement userVerificationRequirement) {
        switch (userVerificationRequirement) {
            case REQUIRED: {
                return true;
            }
            case PREFERRED: {
                return this.webAuthnModelAuthenticator.isCapableOfUserVerification();
            }
            case DISCOURAGED: {
                return false;
            }
        }
        throw new NotImplementedException();
    }
}

