/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.model;

import com.webauthn4j.attestation.AttestationObject;
import com.webauthn4j.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.attestation.authenticator.ECCredentialPublicKey;
import com.webauthn4j.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.attestation.statement.AttestationStatement;
import com.webauthn4j.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.extension.authneticator.SupportedExtensionsAuthenticatorExtensionOutput;
import com.webauthn4j.test.TestData;
import com.webauthn4j.test.authenticator.model.ConstraintException;
import com.webauthn4j.test.authenticator.model.CredentialMapKey;
import com.webauthn4j.test.authenticator.model.GetAssertionRequest;
import com.webauthn4j.test.authenticator.model.GetAssertionResponse;
import com.webauthn4j.test.authenticator.model.InvalidStateException;
import com.webauthn4j.test.authenticator.model.MakeCredentialRequest;
import com.webauthn4j.test.authenticator.model.MakeCredentialResponse;
import com.webauthn4j.test.authenticator.model.NotAllowedException;
import com.webauthn4j.test.authenticator.model.NotSupportedException;
import com.webauthn4j.test.authenticator.model.PublicKeyCredentialSource;
import com.webauthn4j.test.authenticator.model.WebAuthnModelException;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.PublicKeyCredentialDescriptor;
import com.webauthn4j.test.client.PublicKeyCredentialParameters;
import com.webauthn4j.test.client.PublicKeyCredentialRpEntity;
import com.webauthn4j.test.client.PublicKeyCredentialType;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.KeyUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.util.SignatureUtil;
import com.webauthn4j.util.WIP;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@WIP
public class WebAuthnModelAuthenticator {
    byte[] aaGuid;
    private PrivateKey attestationPrivateKey;
    private AttestationCertificatePath attestationCertificatePath;
    private boolean capableOfUserVerification;
    private int counter;
    private Map<CredentialMapKey, PublicKeyCredentialSource> credentialMap;
    private boolean countUpEnabled = true;
    private AuthenticatorDataConverter authenticatorDataConverter = new AuthenticatorDataConverter();

    public WebAuthnModelAuthenticator(PrivateKey attestationPrivateKey, AttestationCertificatePath attestationCertificatePath, boolean capableOfUserVerification, byte[] aaGuid, int counter) {
        this.attestationPrivateKey = attestationPrivateKey;
        this.attestationCertificatePath = attestationCertificatePath;
        this.capableOfUserVerification = capableOfUserVerification;
        this.aaGuid = aaGuid;
        this.counter = counter;
        this.credentialMap = new HashMap<CredentialMapKey, PublicKeyCredentialSource>();
    }

    public WebAuthnModelAuthenticator() {
        this(TestData.USER_VERIFYING_AUTHENTICATOR_ATTESTATION_PRIVATE_KEY, TestData.USER_VERIFYING_AUTHENTICATOR_ATTESTATION_CERTIFICATE_PATH, true, new byte[16], 0);
    }

    public PublicKeyCredentialSource lookup(byte[] credentialId) {
        if (!this.isCapableOfStoringClientSideResidentCredential()) {
            PublicKeyCredentialSource credentialSource = null;
            return credentialSource;
        }
        for (Map.Entry<CredentialMapKey, PublicKeyCredentialSource> entry : this.credentialMap.entrySet()) {
            if (!Arrays.equals(credentialId, entry.getValue().getId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public MakeCredentialResponse makeCredential(MakeCredentialRequest makeCredentialRequest, RegistrationEmulationOption registrationEmulationOption) {
        byte[] credentialId;
        Object userHandle;
        CredentialPublicKey credentialPublicKey;
        PublicKeyCredentialRpEntity rpEntity = makeCredentialRequest.getRpEntity();
        Optional<PublicKeyCredentialParameters> optionalPublicKeyCredentialParameters = makeCredentialRequest.getCredTypesAndPublicKeyAlgs().stream().filter(this::isCapableOfHandling).findFirst();
        if (!optionalPublicKeyCredentialParameters.isPresent()) {
            throw new NotSupportedException("Specified PublicKeyCredentialParameters are not supported");
        }
        PublicKeyCredentialParameters publicKeyCredentialParameters = optionalPublicKeyCredentialParameters.get();
        for (PublicKeyCredentialDescriptor descriptor : makeCredentialRequest.getExcludeCredentialDescriptorList()) {
            PublicKeyCredentialSource publicKeyCredentialSource = this.lookup(descriptor.getId());
            if (publicKeyCredentialSource == null || !publicKeyCredentialSource.getRpId().equals(rpEntity.getId()) || !publicKeyCredentialSource.getType().equals((Object)descriptor.getType())) continue;
            boolean userConsent = true;
            if (userConsent) {
                throw new InvalidStateException("");
            }
            throw new NotAllowedException("User consent is required");
        }
        if (makeCredentialRequest.isRequireResidentKey() && !this.isCapableOfStoringClientSideResidentCredential()) {
            throw new ConstraintException("Authenticator isn't capable of storing client-side resident credential");
        }
        if (makeCredentialRequest.isRequireUserVerification() && !this.isCapableOfUserVerification()) {
            throw new ConstraintException("Authenticator isn't capable of user verification");
        }
        boolean userVerification = true;
        boolean userConsent = true;
        if (makeCredentialRequest.isRequireUserVerification() && !userVerification) {
            throw new NotAllowedException("User is not verified.");
        }
        if (makeCredentialRequest.isRequireUserPresence() && !userConsent) {
            throw new NotAllowedException("User doesn't provide consent.");
        }
        try {
            KeyPair keyPair = KeyUtil.createECKeyPair();
            PrivateKey credentialPrivateKey = keyPair.getPrivate();
            credentialPublicKey = ECCredentialPublicKey.create((ECPublicKey)((ECPublicKey)keyPair.getPublic()));
            userHandle = makeCredentialRequest.getUserEntity().getId();
            PublicKeyCredentialSource credentialSource = new PublicKeyCredentialSource();
            credentialSource.setType(PublicKeyCredentialType.PublicKey);
            credentialSource.setPrivateKey(credentialPrivateKey);
            credentialSource.setRpId(rpEntity.getId());
            credentialSource.setUserHandle((byte[])userHandle);
            credentialSource.setOtherUI(null);
            if (makeCredentialRequest.isRequireResidentKey()) {
                credentialId = new byte[32];
                new SecureRandom().nextBytes(credentialId);
                credentialSource.setId(credentialId);
                Map<CredentialMapKey, PublicKeyCredentialSource> credentials = this.credentialMap;
                credentials.put(new CredentialMapKey(rpEntity.getId(), (byte[])userHandle), credentialSource);
            } else {
                credentialId = null;
            }
        }
        catch (RuntimeException e) {
            throw new WebAuthnModelException(e);
        }
        HashMap<String, SupportedExtensionsAuthenticatorExtensionOutput> processedExtensions = new HashMap<String, SupportedExtensionsAuthenticatorExtensionOutput>();
        userHandle = makeCredentialRequest.getExtensions().entrySet().iterator();
        while (userHandle.hasNext()) {
            Map.Entry entry = (Map.Entry)userHandle.next();
            String extensionIdentifier = (String)entry.getKey();
            if (!extensionIdentifier.equals("exts")) continue;
            processedExtensions.put("exts", new SupportedExtensionsAuthenticatorExtensionOutput(Collections.singletonList("exts")));
        }
        this.countUp();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(rpEntity.getId().getBytes(StandardCharsets.UTF_8));
        byte flag = 64;
        if (userConsent) {
            flag = (byte)(flag | 1);
        }
        if (userVerification) {
            flag = (byte)(flag | 4);
        }
        if (processedExtensions.isEmpty()) {
            flag = (byte)(flag | 0xFFFFFF80);
        }
        AttestedCredentialData attestedCredentialData = new AttestedCredentialData(this.aaGuid, credentialId, credentialPublicKey);
        AuthenticatorData authenticatorData = new AuthenticatorData(rpIdHash, flag, (long)this.counter, attestedCredentialData, processedExtensions);
        PackedAttestationStatement attestationStatement = new PackedAttestationStatement(COSEAlgorithmIdentifier.ES256, null, this.attestationCertificatePath, null);
        AttestationObject attestationObject = new AttestationObject(authenticatorData, (AttestationStatement)attestationStatement);
        MakeCredentialResponse makeCredentialResponse = new MakeCredentialResponse();
        makeCredentialResponse.setAttestationObject(attestationObject);
        return makeCredentialResponse;
    }

    public MakeCredentialResponse makeCredential(MakeCredentialRequest makeCredentialRequest) {
        return this.makeCredential(makeCredentialRequest, new RegistrationEmulationOption());
    }

    public GetAssertionResponse getAssertion(GetAssertionRequest getAssertionRequest, AuthenticationEmulationOption authenticationEmulationOption) {
        byte flags = 0;
        List<Object> credentialOptions = new ArrayList();
        List<PublicKeyCredentialDescriptor> allowCredentialDescriptorList = getAssertionRequest.getAllowCredentialDescriptorList();
        if (allowCredentialDescriptorList != null && !allowCredentialDescriptorList.isEmpty()) {
            for (PublicKeyCredentialDescriptor publicKeyCredentialDescriptor : getAssertionRequest.getAllowCredentialDescriptorList()) {
                PublicKeyCredentialSource credSource = this.lookup(publicKeyCredentialDescriptor.getId());
                if (credSource == null) continue;
                credentialOptions.add(credSource);
            }
        } else {
            for (Map.Entry entry : this.credentialMap.entrySet()) {
                credentialOptions.add(entry.getValue());
            }
        }
        if ((credentialOptions = credentialOptions.stream().filter(item -> item.getRpId().equals(getAssertionRequest.getRpId())).collect(Collectors.toList())).isEmpty()) {
            throw new NotAllowedException("No matching authenticator found");
        }
        if (getAssertionRequest.isRequireUserVerification()) {
            flags = (byte)(flags | 4);
        }
        if (getAssertionRequest.isRequireUserPresence()) {
            flags = (byte)(flags | 1);
        }
        PublicKeyCredentialSource selectedCredential = (PublicKeyCredentialSource)credentialOptions.get(0);
        Map map = Collections.emptyMap();
        if (!map.isEmpty()) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        this.countUp();
        byte[] rpIdHash = MessageDigestUtil.createSHA256().digest(getAssertionRequest.getRpId().getBytes(StandardCharsets.UTF_8));
        AuthenticatorData authenticatorDataObject = new AuthenticatorData(rpIdHash, flags, (long)this.counter, map);
        byte[] authenticatorData = this.authenticatorDataConverter.convert(authenticatorDataObject);
        byte[] clientDataHash = getAssertionRequest.getHash();
        byte[] signedData = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
        byte[] signature = this.calculateSignature(selectedCredential.getPrivateKey(), signedData);
        GetAssertionResponse getAssertionResponse = new GetAssertionResponse();
        getAssertionResponse.setCredentialId(selectedCredential.getId());
        getAssertionResponse.setAuthenticatorData(authenticatorData);
        getAssertionResponse.setSignature(signature);
        getAssertionResponse.setUserHandle(selectedCredential.getUserHandle());
        return getAssertionResponse;
    }

    public GetAssertionResponse getAssertion(GetAssertionRequest getAssertionRequest) {
        return this.getAssertion(getAssertionRequest, new AuthenticationEmulationOption());
    }

    public boolean isCapableOfUserVerification() {
        return this.capableOfUserVerification;
    }

    public boolean isCapableOfStoringClientSideResidentCredential() {
        return true;
    }

    private boolean isCapableOfHandling(PublicKeyCredentialParameters publicKeyCredentialParameters) {
        return publicKeyCredentialParameters.getType() == PublicKeyCredentialType.PublicKey && publicKeyCredentialParameters.getAlg() == COSEAlgorithmIdentifier.ES256;
    }

    public boolean isCountUpEnabled() {
        return this.countUpEnabled;
    }

    public void setCountUpEnabled(boolean countUpEnabled) {
        this.countUpEnabled = countUpEnabled;
    }

    private byte[] calculateSignature(PrivateKey privateKey, byte[] signedData) {
        try {
            Signature signature = SignatureUtil.createSignature((String)"SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(signedData);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new WebAuthnModelException("Signature calculation error", e);
        }
    }

    private void countUp() {
        if (this.isCountUpEnabled()) {
            ++this.counter;
        }
    }
}

