/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.authenticator.webauthn;

import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.test.AttestationCertificateBuilder;
import com.webauthn4j.test.TestDataUtil;
import com.webauthn4j.test.authenticator.webauthn.AndroidKeyAttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.authenticator.webauthn.AttestationStatementRequest;
import com.webauthn4j.test.authenticator.webauthn.WebAuthnModelAuthenticator;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;

public class AndroidKeyAuthenticator
extends WebAuthnModelAuthenticator {
    @Override
    public AttestationStatement createAttestationStatement(AttestationStatementRequest attestationStatementRequest, RegistrationEmulationOption registrationEmulationOption) {
        byte[] signature = registrationEmulationOption.isSignatureOverrideEnabled() ? registrationEmulationOption.getSignature() : TestDataUtil.calculateSignature(attestationStatementRequest.getCredentialKeyPair(), attestationStatementRequest.getSignedData());
        AttestationOption attestationOption = registrationEmulationOption.getAttestationOption() == null ? new AndroidKeyAttestationOption() : registrationEmulationOption.getAttestationOption();
        X509Certificate attestationCertificate = this.getAttestationCertificate(attestationStatementRequest, attestationOption);
        AttestationCertificatePath attestationCertificates = new AttestationCertificatePath(attestationCertificate, (List)this.getCACertificatePath());
        return new AndroidKeyAttestationStatement(COSEAlgorithmIdentifier.ES256, signature, attestationCertificates);
    }

    @Override
    protected X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest, AttestationOption attestationOption) {
        AttestationCertificateBuilder builder = new AttestationCertificateBuilder(this.getAttestationIssuerCertificate(), new X500Principal(attestationOption.getSubjectDN()), attestationStatementRequest.getCredentialKeyPair().getPublicKey());
        builder.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.1.17"), false, this.createKeyDescriptor(attestationStatementRequest.getClientDataHash()));
        builder.addBasicConstraintsExtension();
        builder.addKeyUsageExtension();
        return builder.build(this.getAttestationIssuerPrivateKey());
    }

    private X509Certificate createAttestationCertificate(AttestationStatementRequest attestationStatementRequest) {
        return this.createAttestationCertificate(attestationStatementRequest, new AndroidKeyAttestationOption());
    }

    private ASN1Encodable createKeyDescriptor(byte[] clientDataHash) {
        ASN1Integer attestationVersion = new ASN1Integer(2L);
        ASN1Enumerated attestationSecurityLevel = new ASN1Enumerated(0);
        ASN1Integer keymasterVersion = new ASN1Integer(1L);
        ASN1Enumerated keymasterSecurityLevel = new ASN1Enumerated(0);
        DEROctetString attestationChallenge = new DEROctetString(clientDataHash);
        DEROctetString reserved = new DEROctetString(new byte[0]);
        ASN1EncodableVector softwareEnforcedVector = new ASN1EncodableVector();
        DLSequence softwareEnforced = new DLSequence(softwareEnforcedVector);
        ASN1EncodableVector teeEnforcedVector = new ASN1EncodableVector();
        teeEnforcedVector.add((ASN1Encodable)new DERTaggedObject(702, (ASN1Encodable)new ASN1Integer(0L)));
        teeEnforcedVector.add((ASN1Encodable)new DERTaggedObject(1, (ASN1Encodable)new DERSet((ASN1Encodable)new ASN1Integer(2L))));
        DLSequence teeEnforced = new DLSequence(teeEnforcedVector);
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        asn1EncodableVector.add((ASN1Encodable)attestationVersion);
        asn1EncodableVector.add((ASN1Encodable)attestationSecurityLevel);
        asn1EncodableVector.add((ASN1Encodable)keymasterVersion);
        asn1EncodableVector.add((ASN1Encodable)keymasterSecurityLevel);
        asn1EncodableVector.add((ASN1Encodable)attestationChallenge);
        asn1EncodableVector.add((ASN1Encodable)reserved);
        asn1EncodableVector.add((ASN1Encodable)softwareEnforced);
        asn1EncodableVector.add((ASN1Encodable)teeEnforced);
        return new DLSequence(asn1EncodableVector);
    }
}

