/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.test.client;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AttestationConveyancePreference;
import com.webauthn4j.data.AuthenticatorAssertionResponse;
import com.webauthn4j.data.AuthenticatorAttestationResponse;
import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.PublicKeyCredentialCreationOptions;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.client.TokenBindingStatus;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.CredentialPropertiesOutput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.test.authenticator.AuthenticatorAdaptor;
import com.webauthn4j.test.authenticator.CredentialCreationResponse;
import com.webauthn4j.test.authenticator.CredentialRequestResponse;
import com.webauthn4j.test.authenticator.webauthn.AttestationOption;
import com.webauthn4j.test.client.AuthenticationEmulationOption;
import com.webauthn4j.test.client.NoAuthenticatorSuccessException;
import com.webauthn4j.test.client.RegistrationEmulationOption;
import com.webauthn4j.util.WIP;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.HashMap;
import java.util.Objects;

@WIP
public class ClientPlatform {
    private final ObjectConverter objectConverter = new ObjectConverter();
    private final AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter(this.objectConverter);
    private final CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter(this.objectConverter);
    private Origin origin;
    private AuthenticatorAdaptor authenticatorAdaptor;

    public ClientPlatform(Origin origin, AuthenticatorAdaptor authenticatorAdaptor) {
        this.origin = origin;
        this.authenticatorAdaptor = authenticatorAdaptor;
    }

    public ClientPlatform(AuthenticatorAdaptor authenticatorAdaptor) {
        this(new Origin("https://example.com"), authenticatorAdaptor);
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, RegistrationEmulationOption registrationEmulationOption, AttestationOption attestationOption) {
        CollectedClientData collectedClientData = registrationEmulationOption.isCollectedClientDataOverrideEnabled() ? registrationEmulationOption.getCollectedClientData() : this.createCollectedClientData(ClientDataType.WEBAUTHN_CREATE, publicKeyCredentialCreationOptions.getChallenge());
        if (this.authenticatorAdaptor == null) {
            throw new NoAuthenticatorSuccessException();
        }
        CredentialCreationResponse credentialCreationResponse = this.authenticatorAdaptor.register(publicKeyCredentialCreationOptions, collectedClientData, registrationEmulationOption, attestationOption);
        AttestationObject attestationObject = credentialCreationResponse.getAttestationObject();
        AttestationStatement attestationStatement = credentialCreationResponse.getAttestationObject().getAttestationStatement();
        AttestationConveyancePreference attestationConveyancePreference = publicKeyCredentialCreationOptions.getAttestation();
        if (attestationConveyancePreference == null) {
            attestationConveyancePreference = AttestationConveyancePreference.NONE;
        }
        if (!AttestationConveyancePreference.DIRECT.equals((Object)attestationConveyancePreference)) {
            if (AttestationConveyancePreference.INDIRECT.equals((Object)attestationConveyancePreference)) {
                throw new NotImplementedException();
            }
            if (AttestationConveyancePreference.NONE.equals((Object)attestationConveyancePreference)) {
                attestationStatement = new NoneAttestationStatement();
            } else {
                throw new NotImplementedException();
            }
        }
        attestationObject = new AttestationObject(attestationObject.getAuthenticatorData(), attestationStatement);
        byte[] attestationObjectBytes = this.attestationObjectConverter.convertToBytes(attestationObject);
        byte[] credentialId = credentialCreationResponse.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId();
        byte[] collectedClientDataBytes = this.collectedClientDataConverter.convertToBytes(collectedClientData);
        AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions = this.processRegistrationExtensions((AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>)publicKeyCredentialCreationOptions.getExtensions());
        return new PublicKeyCredential(credentialId, (AuthenticatorResponse)new AuthenticatorAttestationResponse(collectedClientDataBytes, attestationObjectBytes), clientExtensions);
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions, RegistrationEmulationOption registrationEmulationOption) {
        return this.create(publicKeyCredentialCreationOptions, registrationEmulationOption, null);
    }

    private AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> processRegistrationExtensions(AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> extensions) {
        if (extensions == null) {
            extensions = new AuthenticationExtensionsClientInputs();
        }
        AuthenticationExtensionsClientOutputs.BuilderForRegistration builder = new AuthenticationExtensionsClientOutputs.BuilderForRegistration();
        HashMap map = new HashMap();
        extensions.getKeys().forEach(key -> {
            switch (key) {
                case "credProps": {
                    builder.setCredProps(new CredentialPropertiesOutput(Boolean.valueOf(true)));
                    break;
                }
            }
        });
        return builder.build();
    }

    private AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> processAuthenticationExtensions(AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> extensions) {
        if (extensions == null) {
            extensions = new AuthenticationExtensionsClientInputs();
        }
        AuthenticationExtensionsClientOutputs map = new AuthenticationExtensionsClientOutputs();
        extensions.getKeys().forEach(key -> Objects.requireNonNull(key));
        return map;
    }

    public PublicKeyCredential<AuthenticatorAttestationResponse, RegistrationExtensionClientOutput> create(PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions) {
        return this.create(publicKeyCredentialCreationOptions, new RegistrationEmulationOption(), null);
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData, AuthenticationEmulationOption authenticationEmulationOption) {
        NoAuthenticatorSuccessException noAuthenticatorSuccessException = new NoAuthenticatorSuccessException();
        if (this.authenticatorAdaptor == null) {
            throw noAuthenticatorSuccessException;
        }
        try {
            CredentialRequestResponse credentialRequestResponse = this.authenticatorAdaptor.authenticate(publicKeyCredentialRequestOptions, collectedClientData, authenticationEmulationOption);
            byte[] credentialId = credentialRequestResponse.getCredentialId();
            AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = this.processAuthenticationExtensions((AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput>)publicKeyCredentialRequestOptions.getExtensions());
            return new PublicKeyCredential(credentialId, (AuthenticatorResponse)new AuthenticatorAssertionResponse(credentialRequestResponse.getCollectedClientDataBytes(), credentialRequestResponse.getAuthenticatorDataBytes(), credentialRequestResponse.getSignature(), credentialRequestResponse.getUserHandle()), clientExtensions);
        }
        catch (VerificationException e) {
            noAuthenticatorSuccessException.addSuppressed(e);
            throw noAuthenticatorSuccessException;
        }
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, CollectedClientData collectedClientData) {
        return this.get(publicKeyCredentialRequestOptions, collectedClientData, new AuthenticationEmulationOption());
    }

    public PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> get(PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
        CollectedClientData collectedClientData = this.createCollectedClientData(ClientDataType.WEBAUTHN_GET, publicKeyCredentialRequestOptions.getChallenge());
        return this.get(publicKeyCredentialRequestOptions, collectedClientData);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge) {
        return new CollectedClientData(type, challenge, this.origin, null);
    }

    public CollectedClientData createCollectedClientData(ClientDataType type, Challenge challenge, byte[] tokenBindingId) {
        TokenBinding tokenBinding = new TokenBinding(TokenBindingStatus.PRESENT, tokenBindingId);
        return new CollectedClientData(type, challenge, this.origin, tokenBinding);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public AuthenticatorAdaptor getAuthenticatorAdaptor() {
        return this.authenticatorAdaptor;
    }

    public void setAuthenticatorAdaptor(AuthenticatorAdaptor authenticatorAdaptor) {
        this.authenticatorAdaptor = authenticatorAdaptor;
    }
}

