/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.CachingMetadataBLOBProvider;
import com.webauthn4j.metadata.data.MetadataBLOB;
import com.webauthn4j.metadata.data.MetadataBLOBFactory;
import com.webauthn4j.util.AssertUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ResourceMetadataBLOBProvider
extends CachingMetadataBLOBProvider
implements InitializingBean {
    private Resource resource;
    private final MetadataBLOBFactory metadataBLOBFactory;

    public ResourceMetadataBLOBProvider(ObjectConverter objectConverter) {
        this.metadataBLOBFactory = new MetadataBLOBFactory(objectConverter);
    }

    public void afterPropertiesSet() {
        this.checkConfig();
    }

    private void checkConfig() {
        AssertUtil.notNull((Object)this.resource, (String)"resource must not be null");
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    protected MetadataBLOB doProvide() {
        MetadataBLOB metadataBLOB;
        block8: {
            InputStream inputStream = this.resource.getInputStream();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                Stream<String> lines = new BufferedReader(inputStreamReader).lines();
                String string = lines.collect(Collectors.joining());
                metadataBLOB = this.metadataBLOBFactory.parse(string);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to load a MetadataBLOB file", e);
                }
            }
            inputStream.close();
        }
        return metadataBLOB;
    }
}

