/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.metadata;

import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;

public class ResourcesMetadataStatementsProvider
implements MetadataStatementsProvider,
InitializingBean {
    private List<Resource> resources;
    private final ObjectConverter objectConverter;
    private List<MetadataStatement> metadataStatements;

    public ResourcesMetadataStatementsProvider(ObjectConverter objectConverter) {
        this.objectConverter = objectConverter;
    }

    public void afterPropertiesSet() {
        this.checkConfig();
        this.load();
    }

    private void checkConfig() {
        AssertUtil.notNull(this.resources, (String)"resources must not be null");
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    private void load() {
        this.metadataStatements = this.resources.stream().map(resource -> {
            try {
                return (MetadataStatement)this.objectConverter.getJsonConverter().readValue(resource.getInputStream(), MetadataStatement.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NonNull
    public List<MetadataStatement> provide() {
        if (this.metadataStatements == null) {
            this.load();
        }
        return this.metadataStatements;
    }
}

