/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.springframework.security.WebAuthnAuthenticationRequest;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class WebAuthnAuthenticationToken
extends AbstractAuthenticationToken {
    private final Object principal;
    private final WebAuthnAuthenticationRequest credentials;

    public WebAuthnAuthenticationToken(Object principal, WebAuthnAuthenticationRequest credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public WebAuthnAuthenticationRequest getCredentials() {
        return this.credentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebAuthnAuthenticationToken)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnAuthenticationToken that = (WebAuthnAuthenticationToken)((Object)o);
        if (!Objects.equals(this.principal, that.principal)) {
            return false;
        }
        return Objects.equals(this.credentials, that.credentials);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
        result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
        return result;
    }
}

