/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security;

import com.webauthn4j.springframework.security.WebAuthnAuthenticationParameters;
import com.webauthn4j.springframework.security.WebAuthnAuthenticationRequest;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class WebAuthnAssertionAuthenticationToken
extends AbstractAuthenticationToken {
    private WebAuthnAuthenticationRequest credentials;
    private final WebAuthnAuthenticationParameters parameters;

    public WebAuthnAssertionAuthenticationToken(WebAuthnAuthenticationRequest credentials, WebAuthnAuthenticationParameters parameters, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.credentials = credentials;
        this.parameters = parameters;
        this.setAuthenticated(false);
    }

    public Object getPrincipal() {
        return null;
    }

    public WebAuthnAuthenticationRequest getCredentials() {
        return this.credentials;
    }

    public WebAuthnAuthenticationParameters getParameters() {
        return this.parameters;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this credential record to trusted");
        }
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebAuthnAssertionAuthenticationToken that = (WebAuthnAssertionAuthenticationToken)((Object)o);
        return Objects.equals(this.credentials, that.credentials) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.credentials, this.parameters);
    }
}

