/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonFileMetadataStatementsProvider
implements MetadataStatementsProvider {
    private JsonConverter jsonConverter;
    private List<Path> paths = Collections.emptyList();
    private Map<AAGUID, Set<MetadataStatement>> cachedMetadataItems;

    public JsonFileMetadataStatementsProvider(JsonConverter jsonConverter, List<Path> paths) {
        this.jsonConverter = jsonConverter;
        this.paths = paths;
    }

    @Override
    public Map<AAGUID, Set<MetadataStatement>> provide() {
        if (this.cachedMetadataItems == null) {
            this.cachedMetadataItems = this.paths.stream().map(this::readJsonFile).distinct().collect(Collectors.groupingBy(this::extractAAGUID)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue())));
        }
        return this.cachedMetadataItems;
    }

    private AAGUID extractAAGUID(MetadataStatement metadataStatement) {
        switch (metadataStatement.getProtocolFamily()) {
            case "fido2": {
                return metadataStatement.getAaguid();
            }
            case "u2f": {
                return AAGUID.ZERO;
            }
        }
        return AAGUID.NULL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MetadataStatement readJsonFile(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            MetadataStatement metadataStatement = (MetadataStatement)this.jsonConverter.readValue(inputStream, MetadataStatement.class);
            return metadataStatement;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load a metadata statement json file", e);
        }
    }
}

