/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.metadata.MetadataItemsProvider;
import com.webauthn4j.metadata.MetadataItemsResolver;
import com.webauthn4j.metadata.data.MetadataItem;
import com.webauthn4j.response.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetadataItemsResolverImpl<T extends MetadataItem>
implements MetadataItemsResolver<T> {
    private MetadataItemsProvider<T> metadataItemsProvider;

    public MetadataItemsResolverImpl(MetadataItemsProvider<T> metadataItemsProvider) {
        this.metadataItemsProvider = metadataItemsProvider;
    }

    @Override
    public Set<T> resolve(AAGUID aaguid) {
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        Map<AAGUID, Set<T>> metadataItemMap = this.metadataItemsProvider.provide();
        HashSet list = new HashSet();
        list.addAll(metadataItemMap.getOrDefault(AAGUID.NULL, Collections.emptySet()));
        list.addAll(metadataItemMap.getOrDefault(aaguid, Collections.emptySet()));
        return list;
    }
}

