/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.util.internal;

import com.webauthn4j.metadata.data.MetadataBLOBPayloadEntry;
import com.webauthn4j.metadata.data.toc.StatusReport;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MetadataBLOBUtil {
    private MetadataBLOBUtil() {
    }

    public static boolean checkMetadataBLOBPayloadEntry(@NotNull MetadataBLOBPayloadEntry metadataBLOBPayloadEntry, boolean notFidoCertifiedAllowed, boolean selfAssertionSubmittedAllowed) {
        List<StatusReport> statusReports = metadataBLOBPayloadEntry.getStatusReports();
        for (StatusReport report : statusReports) {
            switch (report.getStatus()) {
                case UPDATE_AVAILABLE: {
                    break;
                }
                case FIDO_CERTIFIED: 
                case FIDO_CERTIFIED_L1: 
                case FIDO_CERTIFIED_L1_PLUS: 
                case FIDO_CERTIFIED_L2: 
                case FIDO_CERTIFIED_L2_PLUS: 
                case FIDO_CERTIFIED_L3: 
                case FIDO_CERTIFIED_L3_PLUS: {
                    break;
                }
                case NOT_FIDO_CERTIFIED: {
                    if (notFidoCertifiedAllowed) break;
                    return false;
                }
                case SELF_ASSERTION_SUBMITTED: {
                    if (selfAssertionSubmittedAllowed) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

