/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataBLOBProvider;
import com.webauthn4j.metadata.MetadataStatementRepository;
import com.webauthn4j.metadata.data.MetadataBLOBPayloadEntry;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.metadata.util.internal.MetadataBLOBUtil;
import com.webauthn4j.metadata.util.internal.MetadataStatementUtil;
import com.webauthn4j.util.HexUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataBLOBBasedMetadataStatementRepository
implements MetadataStatementRepository {
    private final List<MetadataBLOBProvider> metadataBLOBProviders;
    private boolean notFidoCertifiedAllowed = false;
    private boolean selfAssertionSubmittedAllowed = false;

    public MetadataBLOBBasedMetadataStatementRepository(MetadataBLOBProvider ... metadataBLOBProviders) {
        this.metadataBLOBProviders = Arrays.asList(metadataBLOBProviders);
    }

    @Override
    public Set<MetadataStatement> find(AAGUID aaguid) {
        return this.metadataBLOBProviders.stream().flatMap(provider -> provider.provide().getPayload().getEntries().stream()).filter(entry -> Objects.equals(entry.getAaguid(), aaguid)).filter(entry -> MetadataBLOBUtil.checkMetadataBLOBPayloadEntry(entry, this.notFidoCertifiedAllowed, this.selfAssertionSubmittedAllowed)).map(MetadataBLOBPayloadEntry::getMetadataStatement).filter(MetadataStatementUtil::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    @Override
    public Set<MetadataStatement> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataBLOBProviders.stream().flatMap(provider -> provider.provide().getPayload().getEntries().stream()).filter(entry -> MetadataBLOBBasedMetadataStatementRepository.matchAttestationCertificateKeyIdentifier(entry, attestationCertificateKeyIdentifier)).map(MetadataBLOBPayloadEntry::getMetadataStatement).filter(MetadataStatementUtil::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    public static boolean matchAttestationCertificateKeyIdentifier(MetadataBLOBPayloadEntry entry, byte[] attestationCertificateKeyIdentifier) {
        MetadataStatement metadataStatement = entry.getMetadataStatement();
        if (metadataStatement == null || metadataStatement.getAttestationCertificateKeyIdentifiers() == null) {
            return false;
        }
        return metadataStatement.getAttestationCertificateKeyIdentifiers().stream().anyMatch(identifier -> Arrays.equals(HexUtil.decode((String)identifier), attestationCertificateKeyIdentifier));
    }

    public boolean isNotFidoCertifiedAllowed() {
        return this.notFidoCertifiedAllowed;
    }

    public void setNotFidoCertifiedAllowed(boolean notFidoCertifiedAllowed) {
        this.notFidoCertifiedAllowed = notFidoCertifiedAllowed;
    }

    public boolean isSelfAssertionSubmittedAllowed() {
        return this.selfAssertionSubmittedAllowed;
    }

    public void setSelfAssertionSubmittedAllowed(boolean selfAssertionSubmittedAllowed) {
        this.selfAssertionSubmittedAllowed = selfAssertionSubmittedAllowed;
    }
}

