/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.AuthenticatorAttestationType;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataStatementRepository;
import com.webauthn4j.metadata.MetadataStatementsProvider;
import com.webauthn4j.metadata.data.statement.MetadataStatement;
import com.webauthn4j.util.HexUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultMetadataStatementRepository
implements MetadataStatementRepository {
    private final MetadataStatementsProvider metadataStatementsProvider;

    public DefaultMetadataStatementRepository(MetadataStatementsProvider metadataStatementsProvider) {
        this.metadataStatementsProvider = metadataStatementsProvider;
    }

    @Override
    public Set<MetadataStatement> find(AAGUID aaguid) {
        return this.metadataStatementsProvider.provide().stream().filter(entry -> Objects.equals(entry.getAaguid(), aaguid)).filter(this::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    @Override
    public Set<MetadataStatement> find(byte[] attestationCertificateKeyIdentifier) {
        return this.metadataStatementsProvider.provide().stream().filter(entry -> {
            if (entry == null || entry.getAttestationCertificateKeyIdentifiers() == null) {
                return false;
            }
            return entry.getAttestationCertificateKeyIdentifiers().stream().anyMatch(identifier -> Arrays.equals(HexUtil.decode((String)identifier), attestationCertificateKeyIdentifier));
        }).filter(this::checkSurrogateMetadataStatementAttestationRootCertificate).collect(Collectors.toSet());
    }

    private boolean checkSurrogateMetadataStatementAttestationRootCertificate(MetadataStatement metadataStatement) {
        boolean isSurrogate;
        boolean bl = isSurrogate = metadataStatement != null && metadataStatement.getAttestationTypes().stream().allMatch(type -> type.equals((Object)AuthenticatorAttestationType.BASIC_SURROGATE));
        if (isSurrogate) {
            return metadataStatement.getAttestationRootCertificates().isEmpty();
        }
        return true;
    }
}

