/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.Base64Util;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class MetadataAAGUIDRelaxedDeserializer
extends StdDeserializer<AAGUID> {
    public MetadataAAGUIDRelaxedDeserializer() {
        super(AAGUID.class);
    }

    @NotNull
    public AAGUID deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        if (value.length() == 32) {
            value = String.format("%s-%s-%s-%s-%s", value.substring(0, 8), value.substring(8, 12), value.substring(12, 16), value.substring(16, 20), value.substring(20, 32));
            return new AAGUID(value);
        }
        if (value.length() == 36) {
            return new AAGUID(value);
        }
        return new AAGUID(Base64Util.decode((String)value));
    }
}

