/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webauthn4j.converter.jackson.deserializer.json.UserVerificationMethodFromStringDeserializer;
import com.webauthn4j.converter.jackson.serializer.json.UserVerificationMethodToStringSerializer;
import com.webauthn4j.data.UserVerificationMethod;
import com.webauthn4j.metadata.data.statement.BiometricAccuracyDescriptor;
import com.webauthn4j.metadata.data.statement.CodeAccuracyDescriptor;
import com.webauthn4j.metadata.data.statement.PatternAccuracyDescriptor;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VerificationMethodDescriptor {
    @JsonSerialize(using=UserVerificationMethodToStringSerializer.class)
    @JsonDeserialize(using=UserVerificationMethodFromStringDeserializer.class)
    private final @Nullable UserVerificationMethod userVerificationMethod;
    private final @Nullable CodeAccuracyDescriptor caDesc;
    private final @Nullable BiometricAccuracyDescriptor baDesc;
    private final @Nullable PatternAccuracyDescriptor paDesc;

    @JsonCreator
    public VerificationMethodDescriptor(@JsonProperty(value="userVerificationMethod") @Nullable UserVerificationMethod userVerificationMethod, @JsonProperty(value="caDesc") @Nullable CodeAccuracyDescriptor caDesc, @JsonProperty(value="baDesc") @Nullable BiometricAccuracyDescriptor baDesc, @JsonProperty(value="paDesc") @Nullable PatternAccuracyDescriptor paDesc) {
        this.userVerificationMethod = userVerificationMethod;
        this.caDesc = caDesc;
        this.baDesc = baDesc;
        this.paDesc = paDesc;
    }

    public @Nullable UserVerificationMethod getUserVerificationMethod() {
        return this.userVerificationMethod;
    }

    public @Nullable CodeAccuracyDescriptor getCaDesc() {
        return this.caDesc;
    }

    public @Nullable BiometricAccuracyDescriptor getBaDesc() {
        return this.baDesc;
    }

    public @Nullable PatternAccuracyDescriptor getPaDesc() {
        return this.paDesc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationMethodDescriptor that = (VerificationMethodDescriptor)o;
        return this.userVerificationMethod == that.userVerificationMethod && Objects.equals(this.caDesc, that.caDesc) && Objects.equals(this.baDesc, that.baDesc) && Objects.equals(this.paDesc, that.paDesc);
    }

    public int hashCode() {
        return Objects.hash(this.userVerificationMethod, this.caDesc, this.baDesc, this.paDesc);
    }
}

