/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.metadata.data.statement.VerificationMethodDescriptor;
import com.webauthn4j.util.AssertUtil;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VerificationMethodANDCombinations
extends AbstractList<VerificationMethodDescriptor> {
    private final int size;
    private final VerificationMethodDescriptor[] descriptors;

    @JsonCreator
    public VerificationMethodANDCombinations(@NonNull List<VerificationMethodDescriptor> descriptors) {
        AssertUtil.notNull(descriptors, (String)"descriptors must not be null");
        this.size = descriptors.size();
        this.descriptors = descriptors.toArray(new VerificationMethodDescriptor[this.size]);
    }

    public VerificationMethodANDCombinations(VerificationMethodDescriptor ... descriptors) {
        AssertUtil.notNull((Object)descriptors, (String)"descriptors must not be null");
        this.size = descriptors.length;
        this.descriptors = descriptors;
    }

    public VerificationMethodANDCombinations() {
        this(Collections.emptyList());
    }

    @Override
    public @NonNull VerificationMethodDescriptor get(int index) {
        return this.descriptors[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerificationMethodANDCombinations that = (VerificationMethodANDCombinations)o;
        return this.size == that.size && Arrays.equals(this.descriptors, that.descriptors);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.descriptors);
        return result;
    }
}

