/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.MetadataItemsProvider;
import com.webauthn4j.metadata.data.MetadataItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatingMetadataItemsProvider
implements MetadataItemsProvider {
    private final Logger logger = LoggerFactory.getLogger(AggregatingMetadataItemsProvider.class);
    private final List<MetadataItemsProvider> metadataItemsProviders;

    public AggregatingMetadataItemsProvider(List<MetadataItemsProvider> metadataItemsProviders) {
        this.metadataItemsProviders = metadataItemsProviders;
    }

    @Override
    public Map<AAGUID, Set<MetadataItem>> provide() {
        HashMap<AAGUID, Set<MetadataItem>> map = new HashMap<AAGUID, Set<MetadataItem>>();
        this.metadataItemsProviders.forEach(provider -> {
            try {
                Map<AAGUID, Set<MetadataItem>> provided = provider.provide();
                provided.keySet().forEach(aaguid -> {
                    map.putIfAbsent((AAGUID)aaguid, new HashSet());
                    ((Set)map.get(aaguid)).addAll((Collection)provided.get(aaguid));
                });
            }
            catch (RuntimeException e) {
                this.logger.warn("Failed to load metadata from one of metadataItemsProviders", (Throwable)e);
            }
        });
        return map;
    }
}

