/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.metadata.data.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.metadata.data.statement.AlternativeDescriptions;
import com.webauthn4j.metadata.data.statement.AttachmentHints;
import com.webauthn4j.metadata.data.statement.AttestationType;
import com.webauthn4j.metadata.data.statement.AuthenticationAlgorithm;
import com.webauthn4j.metadata.data.statement.DisplayPNGCharacteristicsDescriptor;
import com.webauthn4j.metadata.data.statement.EcdaaTrustAnchor;
import com.webauthn4j.metadata.data.statement.ExtensionDescriptor;
import com.webauthn4j.metadata.data.statement.KeyProtections;
import com.webauthn4j.metadata.data.statement.MatcherProtections;
import com.webauthn4j.metadata.data.statement.PublicKeyRepresentationFormat;
import com.webauthn4j.metadata.data.statement.TransactionConfirmationDisplays;
import com.webauthn4j.metadata.data.statement.VerificationMethodANDCombinations;
import com.webauthn4j.metadata.data.statement.Version;
import com.webauthn4j.metadata.data.uaf.AAID;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;

public class MetadataStatement
implements Serializable {
    private final String legalHeader;
    private final AAID aaid;
    private final AAGUID aaguid;
    private final List<String> attestationCertificateKeyIdentifiers;
    private final String description;
    private final AlternativeDescriptions alternativeDescriptions;
    private final Integer authenticatorVersion;
    private final String protocolFamily;
    private final List<Version> upv;
    private final String assertionScheme;
    private final AuthenticationAlgorithm authenticationAlgorithm;
    private final List<AuthenticationAlgorithm> authenticationAlgorithms;
    private final PublicKeyRepresentationFormat publicKeyAlgAndEncoding;
    private final List<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings;
    private final List<AttestationType> attestationTypes;
    private final List<VerificationMethodANDCombinations> userVerificationDetails;
    private final KeyProtections keyProtection;
    private final Boolean isKeyRestricted;
    private final Boolean isFreshUserVerificationRequired;
    private final MatcherProtections matcherProtection;
    private final Integer cryptoStrength;
    private final String operationEnv;
    private final AttachmentHints attachmentHint;
    private final Boolean isSecondFactorOnly;
    private final TransactionConfirmationDisplays tcDisplay;
    private final String tcDisplayContentType;
    private final List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics;
    private final List<X509Certificate> attestationRootCertificates;
    private final List<EcdaaTrustAnchor> ecdaaTrustAnchors;
    private final String icon;
    private final List<ExtensionDescriptor> supportedExtensions;

    @JsonCreator
    public MetadataStatement(@JsonProperty(value="legalHeader") String legalHeader, @JsonProperty(value="aaid") AAID aaid, @JsonProperty(value="aaguid") AAGUID aaguid, @JsonProperty(value="attestationCertificateKeyIdentifiers") List<String> attestationCertificateKeyIdentifiers, @JsonProperty(value="description") String description, @JsonProperty(value="alternativeDescriptions") AlternativeDescriptions alternativeDescriptions, @JsonProperty(value="authenticatorVersion") Integer authenticatorVersion, @JsonProperty(value="protocolFamily") String protocolFamily, @JsonProperty(value="upv") List<Version> upv, @JsonProperty(value="assertionScheme") String assertionScheme, @JsonProperty(value="authenticationAlgorithm") AuthenticationAlgorithm authenticationAlgorithm, @JsonProperty(value="authenticationAlgorithms") List<AuthenticationAlgorithm> authenticationAlgorithms, @JsonProperty(value="publicKeyAlgAndEncoding") PublicKeyRepresentationFormat publicKeyAlgAndEncoding, @JsonProperty(value="publicKeyAlgAndEncodings") List<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings, @JsonProperty(value="attestationTypes") List<AttestationType> attestationTypes, @JsonProperty(value="userVerificationDetails") List<VerificationMethodANDCombinations> userVerificationDetails, @JsonProperty(value="keyProtection") KeyProtections keyProtection, @JsonProperty(value="isKeyRestricted") Boolean isKeyRestricted, @JsonProperty(value="isFreshUserVerificationRequired") Boolean isFreshUserVerificationRequired, @JsonProperty(value="matcherProtection") MatcherProtections matcherProtection, @JsonProperty(value="cryptoStrength") Integer cryptoStrength, @JsonProperty(value="operationEnv") String operationEnv, @JsonProperty(value="attachmentHint") AttachmentHints attachmentHint, @JsonProperty(value="isSecondFactorOnly") Boolean isSecondFactorOnly, @JsonProperty(value="tcDisplay") TransactionConfirmationDisplays tcDisplay, @JsonProperty(value="tcDisplayContentType") String tcDisplayContentType, @JsonProperty(value="tcDisplayPNGCharacteristics") List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics, @JsonProperty(value="attestationRootCertificates") List<X509Certificate> attestationRootCertificates, @JsonProperty(value="ecdaaTrustAnchors") List<EcdaaTrustAnchor> ecdaaTrustAnchors, @JsonProperty(value="icon") String icon, @JsonProperty(value="supportedExtensions") List<ExtensionDescriptor> supportedExtensions) {
        this.legalHeader = legalHeader;
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = CollectionUtil.unmodifiableList(attestationCertificateKeyIdentifiers);
        this.alternativeDescriptions = alternativeDescriptions;
        this.description = description;
        this.authenticatorVersion = authenticatorVersion;
        this.protocolFamily = protocolFamily;
        this.upv = CollectionUtil.unmodifiableList(upv);
        this.assertionScheme = assertionScheme;
        this.authenticationAlgorithm = authenticationAlgorithm;
        this.authenticationAlgorithms = CollectionUtil.unmodifiableList(authenticationAlgorithms);
        this.publicKeyAlgAndEncoding = publicKeyAlgAndEncoding;
        this.publicKeyAlgAndEncodings = CollectionUtil.unmodifiableList(publicKeyAlgAndEncodings);
        this.attestationTypes = attestationTypes;
        this.userVerificationDetails = CollectionUtil.unmodifiableList(userVerificationDetails);
        this.keyProtection = keyProtection;
        this.isKeyRestricted = isKeyRestricted;
        this.isFreshUserVerificationRequired = isFreshUserVerificationRequired;
        this.matcherProtection = matcherProtection;
        this.cryptoStrength = cryptoStrength;
        this.operationEnv = operationEnv;
        this.attachmentHint = attachmentHint;
        this.isSecondFactorOnly = isSecondFactorOnly;
        this.tcDisplay = tcDisplay;
        this.tcDisplayContentType = tcDisplayContentType;
        this.tcDisplayPNGCharacteristics = CollectionUtil.unmodifiableList(tcDisplayPNGCharacteristics);
        this.attestationRootCertificates = CollectionUtil.unmodifiableList(attestationRootCertificates);
        this.ecdaaTrustAnchors = CollectionUtil.unmodifiableList(ecdaaTrustAnchors);
        this.icon = icon;
        this.supportedExtensions = CollectionUtil.unmodifiableList(supportedExtensions);
    }

    public String getLegalHeader() {
        return this.legalHeader;
    }

    public AAID getAaid() {
        return this.aaid;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public List<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    public String getDescription() {
        return this.description;
    }

    public AlternativeDescriptions getAlternativeDescriptions() {
        return this.alternativeDescriptions;
    }

    public Integer getAuthenticatorVersion() {
        return this.authenticatorVersion;
    }

    public String getProtocolFamily() {
        return this.protocolFamily;
    }

    public List<Version> getUpv() {
        return this.upv;
    }

    public String getAssertionScheme() {
        return this.assertionScheme;
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public List<AuthenticationAlgorithm> getAuthenticationAlgorithms() {
        return this.authenticationAlgorithms;
    }

    public PublicKeyRepresentationFormat getPublicKeyAlgAndEncoding() {
        return this.publicKeyAlgAndEncoding;
    }

    public List<PublicKeyRepresentationFormat> getPublicKeyAlgAndEncodings() {
        return this.publicKeyAlgAndEncodings;
    }

    public List<AttestationType> getAttestationTypes() {
        return this.attestationTypes;
    }

    public List<VerificationMethodANDCombinations> getUserVerificationDetails() {
        return this.userVerificationDetails;
    }

    public KeyProtections getKeyProtection() {
        return this.keyProtection;
    }

    public Boolean getKeyRestricted() {
        return this.isKeyRestricted;
    }

    public Boolean getFreshUserVerificationRequired() {
        return this.isFreshUserVerificationRequired;
    }

    public MatcherProtections getMatcherProtection() {
        return this.matcherProtection;
    }

    public Integer getCryptoStrength() {
        return this.cryptoStrength;
    }

    public String getOperationEnv() {
        return this.operationEnv;
    }

    public AttachmentHints getAttachmentHint() {
        return this.attachmentHint;
    }

    public Boolean getSecondFactorOnly() {
        return this.isSecondFactorOnly;
    }

    public TransactionConfirmationDisplays getTcDisplay() {
        return this.tcDisplay;
    }

    public String getTcDisplayContentType() {
        return this.tcDisplayContentType;
    }

    public List<DisplayPNGCharacteristicsDescriptor> getTcDisplayPNGCharacteristics() {
        return this.tcDisplayPNGCharacteristics;
    }

    public List<X509Certificate> getAttestationRootCertificates() {
        return this.attestationRootCertificates;
    }

    public List<EcdaaTrustAnchor> getEcdaaTrustAnchors() {
        return this.ecdaaTrustAnchors;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<ExtensionDescriptor> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

