/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.exception.BadRpIdException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpIdHashValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    RpIdHashValidator() {
    }

    public void validate(byte[] rpIdHash, ServerProperty serverProperty) {
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        String rpId = serverProperty.getRpId();
        AssertUtil.notNull((Object)rpId, (String)"rpId must not be null");
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        byte[] relyingPartyRpIdBytes = rpId.getBytes(StandardCharsets.UTF_8);
        byte[] relyingPartyRpIdHash = messageDigest.digest(relyingPartyRpIdBytes);
        if (!Arrays.equals(rpIdHash, relyingPartyRpIdHash)) {
            this.logger.debug("Authentication failed: bad rpId is specified");
            throw new BadRpIdException("rpIdHash doesn't match the hash of preconfigured rpId.");
        }
    }
}

