/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;

public enum TPMGenerated {
    TPM_GENERATED_VALUE(new byte[]{-1, 84, 67, 71});

    private final byte[] value;

    private TPMGenerated(byte[] value) {
        this.value = value;
    }

    public static TPMGenerated create(byte[] value) {
        if (Arrays.equals(value, TPMGenerated.TPM_GENERATED_VALUE.value)) {
            return TPM_GENERATED_VALUE;
        }
        throw new IllegalArgumentException("value is out of range");
    }

    @JsonCreator
    private static TPMGenerated fromJson(byte[] value) throws InvalidFormatException {
        try {
            return TPMGenerated.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMGenerated.class);
        }
    }

    @JsonValue
    public byte[] getValue() {
        return ArrayUtil.clone((byte[])this.value);
    }
}

