/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.response.WebAuthnAuthenticationContext;
import com.webauthn4j.response.attestation.authenticator.CredentialPublicKey;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.exception.BadSignatureException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

class AssertionSignatureValidator {
    AssertionSignatureValidator() {
    }

    public void validate(WebAuthnAuthenticationContext webAuthnAuthenticationContext, CredentialPublicKey credentialPublicKey) {
        byte[] signedData = this.getSignedData(webAuthnAuthenticationContext);
        byte[] signature = webAuthnAuthenticationContext.getSignature();
        if (!credentialPublicKey.verifySignature(signature, signedData)) {
            throw new BadSignatureException("Bad signature");
        }
    }

    private byte[] getSignedData(WebAuthnAuthenticationContext webAuthnAuthenticationContext) {
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        byte[] rawAuthenticatorData = webAuthnAuthenticationContext.getAuthenticatorData();
        byte[] clientDataHash = messageDigest.digest(webAuthnAuthenticationContext.getClientDataJSON());
        return ByteBuffer.allocate(rawAuthenticatorData.length + clientDataHash.length).put(rawAuthenticatorData).put(clientDataHash).array();
    }
}

