/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util.jws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.response.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.util.jws.JWAIdentifier;
import java.io.Serializable;
import java.util.Objects;

public class JWSHeader
implements Serializable {
    private JWAIdentifier alg;
    private AttestationCertificatePath x5c;

    @JsonCreator
    public JWSHeader(@JsonProperty(value="alg") JWAIdentifier alg, @JsonProperty(value="x5c") AttestationCertificatePath x5c) {
        this.alg = alg;
        this.x5c = x5c;
    }

    @JsonGetter
    public JWAIdentifier getAlg() {
        return this.alg;
    }

    @JsonGetter
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWSHeader jwsHeader = (JWSHeader)o;
        return this.alg == jwsHeader.alg && Objects.equals(this.x5c, jwsHeader.x5c);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alg, this.x5c});
    }
}

