/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.webauthn4j.response.attestation.statement.TPMGenerated;
import com.webauthn4j.response.attestation.statement.TPMISTAttest;
import com.webauthn4j.response.attestation.statement.TPMSClockInfo;
import com.webauthn4j.response.attestation.statement.TPMUAttest;
import com.webauthn4j.response.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class TPMSAttest
implements Serializable {
    private TPMGenerated magic;
    private TPMISTAttest type;
    private byte[] qualifiedSigner;
    private byte[] extraData;
    private TPMSClockInfo clockInfo;
    private BigInteger firmwareVersion;
    private TPMUAttest attested;

    public TPMSAttest(TPMGenerated magic, TPMISTAttest type, byte[] qualifiedSigner, byte[] extraData, TPMSClockInfo clockInfo, BigInteger firmwareVersion, TPMUAttest attested) {
        this.magic = magic;
        this.type = type;
        this.qualifiedSigner = qualifiedSigner;
        this.extraData = extraData;
        this.clockInfo = clockInfo;
        this.firmwareVersion = firmwareVersion;
        this.attested = attested;
    }

    public TPMGenerated getMagic() {
        return this.magic;
    }

    public TPMISTAttest getType() {
        return this.type;
    }

    public byte[] getQualifiedSigner() {
        return ArrayUtil.clone((byte[])this.qualifiedSigner);
    }

    public byte[] getExtraData() {
        return ArrayUtil.clone((byte[])this.extraData);
    }

    public TPMSClockInfo getClockInfo() {
        return this.clockInfo;
    }

    public BigInteger getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public TPMUAttest getAttested() {
        return this.attested;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(this.getMagic().getValue());
            stream.write(this.getType().getValue());
            TPMUtil.writeSizedArray(stream, this.getQualifiedSigner());
            TPMUtil.writeSizedArray(stream, this.getExtraData());
            stream.write(this.getClockInfo().getBytes());
            stream.write(UnsignedNumberUtil.toBytes((BigInteger)this.getFirmwareVersion()));
            stream.write(this.getAttested().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSAttest that = (TPMSAttest)o;
        return this.magic == that.magic && this.type == that.type && Arrays.equals(this.qualifiedSigner, that.qualifiedSigner) && Arrays.equals(this.extraData, that.extraData) && Objects.equals(this.clockInfo, that.clockInfo) && Objects.equals(this.firmwareVersion, that.firmwareVersion) && Objects.equals(this.attested, that.attested);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.magic, this.type, this.clockInfo, this.firmwareVersion, this.attested});
        result = 31 * result + Arrays.hashCode(this.qualifiedSigner);
        result = 31 * result + Arrays.hashCode(this.extraData);
        return result;
    }
}

