/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.response.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum COSEAlgorithmIdentifier {
    RS1(-65535L, "SHA1withRSA", "SHA-1"),
    RS256(-257L, "SHA256withRSA", "SHA-256"),
    RS384(-258L, "SHA384withRSA", "SHA-384"),
    RS512(-259L, "SHA512withRSA", "SHA-512"),
    ES256(-7L, "SHA256withECDSA", "SHA-256"),
    ES384(-35L, "SHA384withECDSA", "SHA-384"),
    ES512(-36L, "SHA512withECDSA", "SHA-512");

    private final long value;
    private final String jcaName;
    private final String messageDigestJcaName;

    private COSEAlgorithmIdentifier(long value, String jcaName, String messageDigestJcaName) {
        this.value = value;
        this.jcaName = jcaName;
        this.messageDigestJcaName = messageDigestJcaName;
    }

    @JsonCreator
    public static COSEAlgorithmIdentifier create(int value) throws InvalidFormatException {
        switch (value) {
            case -65535: {
                return RS1;
            }
            case -257: {
                return RS256;
            }
            case -258: {
                return RS384;
            }
            case -259: {
                return RS512;
            }
            case -7: {
                return ES256;
            }
            case -35: {
                return ES384;
            }
            case -36: {
                return ES512;
            }
        }
        throw new InvalidFormatException(null, "value is out of range", (Object)value, COSEAlgorithmIdentifier.class);
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    public String getMessageDigestJcaName() {
        return this.messageDigestJcaName;
    }
}

