/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.request;

import com.webauthn4j.request.AuthenticatorTransport;
import com.webauthn4j.request.PublicKeyCredentialType;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PublicKeyCredentialDescriptor
implements Serializable {
    private PublicKeyCredentialType type;
    private byte[] id;
    private List<AuthenticatorTransport> transports;

    public PublicKeyCredentialDescriptor(PublicKeyCredentialType type, byte[] id, List<AuthenticatorTransport> transports) {
        this.type = type;
        this.id = id;
        this.transports = CollectionUtil.unmodifiableList(transports);
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public List<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialDescriptor that = (PublicKeyCredentialDescriptor)o;
        return this.type == that.type && Arrays.equals(this.id, that.id) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.transports});
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }
}

