/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum AttestationConveyancePreference {
    NONE("none"),
    INDIRECT("indirect"),
    DIRECT("direct");

    private String value;

    private AttestationConveyancePreference(String value) {
        this.value = value;
    }

    public static AttestationConveyancePreference create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "none": {
                return NONE;
            }
            case "indirect": {
                return INDIRECT;
            }
            case "direct": {
                return DIRECT;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static AttestationConveyancePreference fromJson(String value) throws InvalidFormatException {
        try {
            return AttestationConveyancePreference.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttestationConveyancePreference.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

