/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.WebAuthnCBORModule;
import com.webauthn4j.converter.jackson.WebAuthnJSONModule;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;

public class JsonConverter
implements Serializable {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private ObjectMapper jsonMapper;
    private ObjectMapper cborMapper;
    private boolean jsonMapperInitialized = false;
    private boolean cborMapperInitialized = false;
    private CborConverter cborConverter;

    public JsonConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper) {
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.jsonMapper = jsonMapper;
        this.cborMapper = cborMapper;
    }

    public JsonConverter() {
        this(new ObjectMapper(new JsonFactory()), new ObjectMapper((JsonFactory)new CBORFactory()));
    }

    public <T> T readValue(String src, Class valueType) {
        try {
            return (T)this.getJsonMapper().readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, Class valueType) {
        try {
            return (T)this.getJsonMapper().readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(String src, TypeReference valueTypeRef) {
        try {
            return (T)this.getJsonMapper().readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T readValue(InputStream src, TypeReference valueTypeRef) {
        try {
            return (T)this.getJsonMapper().readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) {
        try {
            return this.getJsonMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public String writeValueAsString(Object value) {
        try {
            return this.getJsonMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public ObjectMapper getJsonMapper() {
        if (!this.jsonMapperInitialized) {
            this.jsonMapper.registerModule((Module)new WebAuthnJSONModule(this, this.getCborConverter()));
            this.jsonMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
            this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.jsonMapperInitialized = true;
        }
        return this.jsonMapper;
    }

    public ObjectMapper getCborMapper() {
        if (!this.cborMapperInitialized) {
            this.cborMapper.registerModule((Module)new WebAuthnCBORModule(this, this.getCborConverter()));
            this.cborMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
            this.cborMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.cborMapperInitialized = true;
        }
        return this.cborMapper;
    }

    public CborConverter getCborConverter() {
        if (this.cborConverter == null) {
            this.cborConverter = new CborConverter(this.jsonMapper, this.cborMapper);
        }
        return this.cborConverter;
    }
}

