/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.jws.JWS;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JWSSerializer
extends StdSerializer<JWS> {
    public JWSSerializer() {
        super(JWS.class);
    }

    public void serialize(JWS value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String data = value.getHeaderString() + "." + value.getPayloadString() + "." + Base64UrlUtil.encodeToString((byte[])value.getSignature());
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        gen.writeBinary(bytes);
    }
}

