/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.request.extension.client.ExtensionClientInput;
import com.webauthn4j.request.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.request.extension.client.SupportedExtensionsExtensionClientInput;
import com.webauthn4j.response.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.response.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.response.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.response.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.response.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.response.attestation.statement.TPMAttestationStatement;
import com.webauthn4j.response.client.challenge.Challenge;
import com.webauthn4j.response.extension.client.AuthenticatorSelectionExtensionClientOutput;
import com.webauthn4j.response.extension.client.BiometricAuthenticatorPerformanceBoundsExtensionClientOutput;
import com.webauthn4j.response.extension.client.ExtensionClientOutput;
import com.webauthn4j.response.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.response.extension.client.GenericTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.response.extension.client.LocationExtensionClientOutput;
import com.webauthn4j.response.extension.client.SimpleTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.response.extension.client.SupportedExtensionsExtensionClientOutput;
import com.webauthn4j.response.extension.client.UserVerificationIndexExtensionClientOutput;
import com.webauthn4j.util.jws.JWS;
import java.security.cert.X509Certificate;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(JsonConverter jsonConverter, CborConverter cborConverter) {
        super("WebAuthnJSONModule");
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(ExtensionClientInput.class, (JsonDeserializer)new ExtensionClientInputDeserializer());
        this.addDeserializer(ExtensionClientOutput.class, (JsonDeserializer)new ExtensionClientOutputDeserializer());
        this.addDeserializer(JWS.class, (JsonDeserializer)new JWSDeserializer(jsonConverter));
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer(Challenge.class, (JsonSerializer)new ChallengeSerializer());
        this.addSerializer(JWS.class, (JsonSerializer)new JWSSerializer());
        this.addSerializer(X509Certificate.class, (JsonSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOU2FAttestationStatement.class, "fido-u2f")});
        this.registerSubtypes(new NamedType[]{new NamedType(PackedAttestationStatement.class, "packed")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidKeyAttestationStatement.class, "android-key")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidSafetyNetAttestationStatement.class, "android-safetynet")});
        this.registerSubtypes(new NamedType[]{new NamedType(TPMAttestationStatement.class, "tpm")});
        this.registerSubtypes(new NamedType[]{new NamedType(NoneAttestationStatement.class, "none")});
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientInput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientInput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(AuthenticatorSelectionExtensionClientOutput.class, "authnSel")});
        this.registerSubtypes(new NamedType[]{new NamedType(BiometricAuthenticatorPerformanceBoundsExtensionClientOutput.class, "biometricPerfBounds")});
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientOutput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(GenericTransactionAuthorizationExtensionClientOutput.class, "txAuthGeneric")});
        this.registerSubtypes(new NamedType[]{new NamedType(LocationExtensionClientOutput.class, "loc")});
        this.registerSubtypes(new NamedType[]{new NamedType(SimpleTransactionAuthorizationExtensionClientOutput.class, "txAuthSimple")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientOutput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(UserVerificationIndexExtensionClientOutput.class, "uvi")});
    }
}

