/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.client.Origin;
import com.webauthn4j.client.challenge.Challenge;
import com.webauthn4j.converter.jackson.deserializer.AuthenticatorDataDeserializer;
import com.webauthn4j.converter.jackson.deserializer.AuthenticatorExtensionOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.CertPathDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ClientExtensionOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.AuthenticatorDataSerializer;
import com.webauthn4j.converter.jackson.serializer.CertPathSerializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.extension.authneticator.AuthenticatorExtensionOutput;
import com.webauthn4j.extension.client.ClientExtensionOutput;
import com.webauthn4j.registry.Registry;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;

public class WebAuthnModule
extends SimpleModule {
    public WebAuthnModule(Registry registry) {
        super("WebAuthnModule");
        this.addDeserializer(CertPath.class, (JsonDeserializer)new CertPathDeserializer());
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(AuthenticatorData.class, (JsonDeserializer)new AuthenticatorDataDeserializer(registry));
        this.addDeserializer(AuthenticatorExtensionOutput.class, (JsonDeserializer)new AuthenticatorExtensionOutputDeserializer());
        this.addDeserializer(ClientExtensionOutput.class, (JsonDeserializer)new ClientExtensionOutputDeserializer());
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer(CertPath.class, (JsonSerializer)new CertPathSerializer());
        this.addSerializer(Challenge.class, (JsonSerializer)new ChallengeSerializer());
        this.addSerializer(Origin.class, (JsonSerializer)new OriginSerializer());
        this.addSerializer(AuthenticatorData.class, (JsonSerializer)new AuthenticatorDataSerializer(registry));
        this.addSerializer(X509Certificate.class, (JsonSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new Class[]{FIDOU2FAttestationStatement.class});
        this.registerSubtypes(new Class[]{PackedAttestationStatement.class});
        this.registerSubtypes(new Class[]{NoneAttestationStatement.class});
    }
}

