/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.extension.client.AuthenticatorSelectionClientExtensionOutput;
import com.webauthn4j.extension.client.BiometricAuthenticatorPerformanceBoundsClientExtensionOutput;
import com.webauthn4j.extension.client.ClientExtensionOutput;
import com.webauthn4j.extension.client.FIDOAppIDClientExtensionOutput;
import com.webauthn4j.extension.client.GenericTransactionAuthorizationClientExtensionOutput;
import com.webauthn4j.extension.client.LocationClientExtensionOutput;
import com.webauthn4j.extension.client.SimpleTransactionAuthorizationClientExtensionOutput;
import com.webauthn4j.extension.client.SupportedExtensionsClientExtensionOutput;
import com.webauthn4j.extension.client.UserVerificationIndexClientExtensionOutput;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;

public class ClientExtensionOutputDeserializer
extends StdDeserializer<ClientExtensionOutput> {
    public ClientExtensionOutputDeserializer() {
        super(ClientExtensionOutput.class);
    }

    public ClientExtensionOutput deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String currentName = p.getParsingContext().getCurrentName();
        if ("appid".equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, FIDOAppIDClientExtensionOutput.class);
        }
        if ("txAuthSimple".equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, SimpleTransactionAuthorizationClientExtensionOutput.class);
        }
        if ("uvi".equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, UserVerificationIndexClientExtensionOutput.class);
        }
        if ("authnSel".equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, AuthenticatorSelectionClientExtensionOutput.class);
        }
        if ("biometricPerfBounds".equals(currentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, BiometricAuthenticatorPerformanceBoundsClientExtensionOutput.class);
        }
        String parentName = p.getParsingContext().getParent().getCurrentName();
        if ("txAuthGeneric".equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, GenericTransactionAuthorizationClientExtensionOutput.class);
        }
        if ("exts".equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, SupportedExtensionsClientExtensionOutput.class);
        }
        if ("loc".equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, LocationClientExtensionOutput.class);
        }
        if ("uvi".equals(parentName)) {
            return (ClientExtensionOutput)ctxt.readValue(p, UserVerificationIndexClientExtensionOutput.class);
        }
        throw new NotImplementedException();
    }
}

